/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.diffing.match;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.match.resource.StrategyResourceMatcher;
import org.eclipse.emf.ecore.resource.Resource;
import org.splevo.diffing.util.NormalizationUtil;

public class HierarchicalStrategyResourceMatcher
extends StrategyResourceMatcher {
    private ListMultimap<String, Resource> filenameResourcesIndexLeft = ArrayListMultimap.create();
    private ListMultimap<String, Resource> filenameResourcesIndexRight = ArrayListMultimap.create();
    private LinkedHashMap<Pattern, String> uriNormalizationPatterns = Maps.newLinkedHashMap();
    private LinkedHashMap<Pattern, String> filenameNormalizationPatterns = Maps.newLinkedHashMap();

    public HierarchicalStrategyResourceMatcher() {
    }

    public HierarchicalStrategyResourceMatcher(LinkedHashMap<Pattern, String> uriNormalizationPatterns, LinkedHashMap<Pattern, String> fileNameNormalizationPatterns) {
        this.uriNormalizationPatterns = uriNormalizationPatterns;
        this.filenameNormalizationPatterns = fileNameNormalizationPatterns;
    }

    public Iterable<MatchResource> createMappings(Iterator<? extends Resource> leftResources, Iterator<? extends Resource> rightResources, Iterator<? extends Resource> originResources) {
        ArrayList<MatchResource> mappings = new ArrayList<MatchResource>();
        this.indexResources(leftResources, this.filenameResourcesIndexLeft, this.filenameNormalizationPatterns);
        this.indexResources(rightResources, this.filenameResourcesIndexRight, null);
        Sets.SetView allSegments = Sets.union((Set)this.filenameResourcesIndexLeft.keySet(), (Set)this.filenameResourcesIndexRight.keySet());
        ArrayList allSegmentsCopy = Lists.newArrayList((Iterable)allSegments);
        for (String segment : allSegmentsCopy) {
            ArrayList leftCandidates = Lists.newArrayList((Iterable)this.filenameResourcesIndexLeft.get((Object)segment));
            ArrayList rightCandidates = Lists.newArrayList((Iterable)this.filenameResourcesIndexRight.get((Object)segment));
            if (leftCandidates.size() == 1 && rightCandidates.size() == 1) {
                Resource left = (Resource)leftCandidates.get(0);
                Resource right = (Resource)rightCandidates.get(0);
                mappings.add(HierarchicalStrategyResourceMatcher.createMatchResource((Resource)left, (Resource)right, null));
                this.removeFromIndex(this.filenameResourcesIndexLeft, left);
                this.removeFromIndex(this.filenameResourcesIndexRight, right);
                continue;
            }
            if (leftCandidates.size() == 0 || rightCandidates.size() == 0) continue;
            this.matchBestMatches(leftCandidates, rightCandidates, mappings);
        }
        LinkedHashSet remainingLeftResources = Sets.newLinkedHashSet((Iterable)this.filenameResourcesIndexLeft.values());
        for (Resource left : remainingLeftResources) {
            mappings.add(HierarchicalStrategyResourceMatcher.createMatchResource((Resource)left, null, null));
        }
        LinkedHashSet remainingRightResources = Sets.newLinkedHashSet((Iterable)this.filenameResourcesIndexRight.values());
        for (Resource right : remainingRightResources) {
            mappings.add(HierarchicalStrategyResourceMatcher.createMatchResource(null, (Resource)right, null));
        }
        return mappings;
    }

    private void matchBestMatches(List<Resource> leftCandidates, List<Resource> rightCandidates, List<MatchResource> mappings) {
        HashMap<Resource, Integer> bestMatchCountIndex = new HashMap<Resource, Integer>();
        LinkedListMultimap bestMatchIndexLeft = LinkedListMultimap.create();
        LinkedListMultimap bestMatchIndexRight = LinkedListMultimap.create();
        for (Resource leftRes : leftCandidates) {
            for (Resource rightRes : rightCandidates) {
                int matchCount = this.getMatchingSegmentsPathOnly(leftRes, rightRes);
                if (!bestMatchCountIndex.containsKey(leftRes) || bestMatchCountIndex.get(leftRes) < matchCount) {
                    bestMatchCountIndex.put(leftRes, matchCount);
                    bestMatchIndexLeft.removeAll((Object)leftRes);
                    bestMatchIndexLeft.put((Object)leftRes, (Object)rightRes);
                } else if (bestMatchCountIndex.get(leftRes) == matchCount) {
                    bestMatchCountIndex.put(leftRes, matchCount);
                    bestMatchIndexLeft.put((Object)leftRes, (Object)rightRes);
                }
                if (!bestMatchCountIndex.containsKey(rightRes) || bestMatchCountIndex.get(rightRes) < matchCount) {
                    bestMatchCountIndex.put(rightRes, matchCount);
                    bestMatchIndexRight.removeAll((Object)rightRes);
                    bestMatchIndexRight.put((Object)rightRes, (Object)leftRes);
                    continue;
                }
                if (bestMatchCountIndex.get(rightRes) != matchCount) continue;
                bestMatchCountIndex.put(rightRes, matchCount);
                bestMatchIndexRight.put((Object)rightRes, (Object)leftRes);
            }
        }
        List<MatchResource> bestMatches = this.createMatchElementsForBestMatches(bestMatchCountIndex, (LinkedListMultimap<Resource, Resource>)bestMatchIndexLeft);
        mappings.addAll(bestMatches);
    }

    private List<MatchResource> createMatchElementsForBestMatches(HashMap<Resource, Integer> bestMatchCountIndex, LinkedListMultimap<Resource, Resource> bestMatchIndexLeft) {
        List<Object> mappings = Lists.newArrayList();
        for (Resource leftRes : bestMatchIndexLeft.keySet()) {
            List rightRessources = bestMatchIndexLeft.get((Object)leftRes);
            for (Resource rightRes : rightRessources) {
                if (bestMatchCountIndex.get(leftRes) != bestMatchCountIndex.get(rightRes)) continue;
                mappings.add(HierarchicalStrategyResourceMatcher.createMatchResource((Resource)leftRes, (Resource)rightRes, null));
                this.removeFromIndex(this.filenameResourcesIndexLeft, leftRes);
                this.removeFromIndex(this.filenameResourcesIndexRight, rightRes);
            }
        }
        mappings = this.filterDuplicateMappings((List<MatchResource>)mappings);
        return mappings;
    }

    private List<MatchResource> filterDuplicateMappings(List<MatchResource> matches) {
        LinkedList filteredMatches = Lists.newLinkedList(matches);
        LinkedHashMultimap rightMatchedIndex = LinkedHashMultimap.create();
        for (MatchResource match : matches) {
            Resource right = match.getRight();
            if (right == null) continue;
            rightMatchedIndex.get((Object)right).add(match);
        }
        for (Resource right : rightMatchedIndex.keySet()) {
            if (rightMatchedIndex.get((Object)right).size() <= 1) continue;
            String rightName = right.getURI().lastSegment();
            for (MatchResource match : rightMatchedIndex.get((Object)right)) {
                Resource left = match.getLeft();
                String leftName = Strings.nullToEmpty((String)left.getURI().lastSegment());
                if (!leftName.equals(rightName)) continue;
                filteredMatches.remove(match);
            }
        }
        return filteredMatches;
    }

    private void removeFromIndex(ListMultimap<String, Resource> index, Resource resource) {
        ArrayList keys = Lists.newArrayList((Iterable)index.keySet());
        for (String key : keys) {
            index.remove((Object)key, (Object)resource);
        }
    }

    private int getMatchingSegmentsPathOnly(Resource leftResource, Resource rightResource) {
        URI leftURI = leftResource.getURI();
        URI rightUri = rightResource.getURI();
        int count = 0;
        String[] segmentsLeft = this.processRenamingNormalizations(leftURI.segments());
        String[] segmentsRight = rightUri.segments();
        segmentsLeft = this.removeLast(segmentsLeft);
        segmentsRight = this.removeLast(segmentsRight);
        int leftLength = segmentsLeft.length;
        int rightLength = segmentsRight.length;
        int i = 0;
        while (i < leftLength) {
            String compString;
            String refString;
            if (i >= rightLength || !(refString = segmentsLeft[leftLength - 1 - i]).equals(compString = segmentsRight[rightLength - 1 - i])) break;
            ++count;
            ++i;
        }
        return count;
    }

    private String[] removeLast(String[] array) {
        if (array == null || array.length == 0) {
            return new String[0];
        }
        return Arrays.copyOfRange(array, 0, array.length - 1);
    }

    private String[] processRenamingNormalizations(String[] segmentsLeft) {
        String leftFilename = segmentsLeft[segmentsLeft.length - 1];
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < segmentsLeft.length - 1) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(segmentsLeft[i]);
            ++i;
        }
        String leftSegmentsAsString = NormalizationUtil.normalizeNamespace(sb.toString(), this.uriNormalizationPatterns);
        ArrayList split = Lists.newArrayList((Iterable)Splitter.on((char)'.').split((CharSequence)leftSegmentsAsString));
        split.add(leftFilename);
        segmentsLeft = (String[])Iterables.toArray((Iterable)split, String.class);
        return segmentsLeft;
    }

    private void indexResources(Iterator<? extends Resource> resources, ListMultimap<String, Resource> index, Map<Pattern, String> fileNameNormalizationPatterns) {
        while (resources.hasNext()) {
            Resource res = resources.next();
            String filename = res.getURI().lastSegment();
            index.put((Object)filename, (Object)res);
            if (fileNameNormalizationPatterns == null) continue;
            for (Pattern pattern : fileNameNormalizationPatterns.keySet()) {
                String replace = fileNameNormalizationPatterns.get(pattern);
                String newFilename = pattern.matcher(filename).replaceAll(replace);
                if (filename.equals(newFilename)) continue;
                index.put((Object)newFilename, (Object)res);
            }
        }
    }
}

