/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.diffing;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.splevo.diffing.Differ;
import org.splevo.diffing.DifferRegistry;
import org.splevo.diffing.DiffingException;
import org.splevo.diffing.DiffingNotSupportedException;
import org.splevo.diffing.DiffingService;

public class DefaultDiffingService
implements DiffingService {
    private Logger logger = Logger.getLogger(DefaultDiffingService.class);
    private static final String MSG_DIFFER_NOT_SELECTED = "No differ selected.";

    @Override
    public Comparison diffSoftwareModels(List<String> differIds, ResourceSet leadingModel, ResourceSet integrationModel, Map<String, String> diffingOptions) throws DiffingException {
        if (differIds.size() == 0) {
            throw new DiffingException(String.format(MSG_DIFFER_NOT_SELECTED, new Object[0]));
        }
        Comparison diffModel = CompareFactory.eINSTANCE.createComparison();
        diffModel.setThreeWay(false);
        for (String differId : differIds) {
            Differ differ = (Differ)DifferRegistry.getInstance().getElementById(differId);
            if (differ == null) {
                this.logger.warn((Object)("Selected Differ not registered: " + differId));
                continue;
            }
            try {
                Comparison partComparisonModel = differ.doDiff(leadingModel, integrationModel, diffingOptions);
                diffModel.getMatches().addAll((Collection)partComparisonModel.getMatches());
                diffModel.getMatchedResources().addAll((Collection)partComparisonModel.getMatchedResources());
            }
            catch (DiffingNotSupportedException e) {
                this.logger.info((Object)"The differ does not support the provided input");
            }
        }
        return diffModel;
    }
}

