/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.extraction;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.splevo.extraction.ExtractionService;
import org.splevo.extraction.SoftwareModelExtractionException;
import org.splevo.extraction.SoftwareModelExtractor;

public class DefaultExtractionService
implements ExtractionService {
    private Logger logger = Logger.getLogger(DefaultExtractionService.class);
    private Map<String, SoftwareModelExtractor> registeredExtractors = null;
    private static final String MSG_EXTRACTOR_NOT_AVAILABLE = "No software extractor available for the provided id: %1";
    private static final String EXTRACTOR_EXTENSION_POINT_ID = "org.splevo.extraction.softwareextractor";
    private static final String EXTENSION_POINT_ATTR_EXTRACTOR_CLASS = "extractor.class";

    @Override
    public ResourceSet extractSoftwareModel(String extractorId, List<String> projectPaths, IProgressMonitor monitor, String targetURI) throws SoftwareModelExtractionException {
        SoftwareModelExtractor extractor = this.getSoftwareModelExtractors().get(extractorId);
        if (extractor == null) {
            throw new SoftwareModelExtractionException(String.format(MSG_EXTRACTOR_NOT_AVAILABLE, extractorId));
        }
        ResourceSet resourceSet = extractor.extractSoftwareModel(projectPaths, monitor, targetURI);
        this.logger.info((Object)("Extraction done: " + targetURI));
        return resourceSet;
    }

    @Override
    public Map<String, SoftwareModelExtractor> getSoftwareModelExtractors() {
        IExtension[] extensions;
        if (this.registeredExtractors != null) {
            return this.registeredExtractors;
        }
        this.registeredExtractors = new LinkedHashMap<String, SoftwareModelExtractor>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            this.logger.warn((Object)"No extension point registry available.");
            return null;
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTRACTOR_EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            this.logger.warn((Object)"No extension point found for the ID org.splevo.extraction.softwareextractor");
            return null;
        }
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configurations;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configurations = extension.getConfigurationElements();
            int n3 = configurations.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    Object o = element.createExecutableExtension(EXTENSION_POINT_ATTR_EXTRACTOR_CLASS);
                    if (o != null && o instanceof SoftwareModelExtractor) {
                        SoftwareModelExtractor extractor = (SoftwareModelExtractor)o;
                        this.registeredExtractors.put(extractor.getId(), extractor);
                    }
                }
                catch (CoreException e) {
                    this.logger.error((Object)"Failed to load software model extractor extension", (Throwable)e);
                }
                ++n4;
            }
            ++n2;
        }
        return this.registeredExtractors;
    }

    @Override
    public void prepareResourceSet(ResourceSet resourceSet, List<String> sourceModelPaths, boolean loadLayoutInformation) {
        Map<String, SoftwareModelExtractor> extractors = this.getSoftwareModelExtractors();
        for (String key : extractors.keySet()) {
            extractors.get(key).prepareResourceSet(resourceSet, sourceModelPaths, loadLayoutInformation);
        }
    }
}

