/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.fm.builder;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.splevo.fm.builder.FeatureModelBuilder;
import org.splevo.fm.builder.FeatureModelBuilderRegistry;

public class Activator
implements BundleActivator {
    private static Logger logger = Logger.getLogger(Activator.class);
    private static final String BUILDER_EXTENSION_POINT_ID = "org.splevo.fm.builder";
    private static final String EXTENSION_POINT_ATTR_BUILDER_CLASS = "builder.class";
    private static BundleContext context;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.loadRegisteredFeatureModelBuilders();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }

    private void loadRegisteredFeatureModelBuilders() {
        IExtensionPoint extensionPoint;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null && (extensionPoint = registry.getExtensionPoint(BUILDER_EXTENSION_POINT_ID)) != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configurations;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configurations = extension.getConfigurationElements();
                int n3 = configurations.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    try {
                        Object o = element.createExecutableExtension(EXTENSION_POINT_ATTR_BUILDER_CLASS);
                        if (o != null && o instanceof FeatureModelBuilder) {
                            FeatureModelBuilder extractor = (FeatureModelBuilder)o;
                            FeatureModelBuilderRegistry.getInstance().registerElement(extractor);
                        }
                    }
                    catch (CoreException e) {
                        logger.error((Object)"Failed to load feature model builder extension", (Throwable)e);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }
}

