/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.fm.emffeaturemodel.builder;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.featuremodel.Feature;
import org.eclipse.featuremodel.FeatureModel;
import org.eclipse.featuremodel.FeatureModelFactory;
import org.eclipse.featuremodel.Group;
import org.eclipse.featuremodel.diagrameditor.FMEDiagramEditorUtil;
import org.splevo.fm.builder.FeatureModelBuilder;
import org.splevo.fm.builder.FeatureModelWrapper;
import org.splevo.fm.emffeaturemodel.builder.FeatureModelUtil;
import org.splevo.vpm.variability.VariabilityType;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;

public class EMFFeatureModelBuilder
implements FeatureModelBuilder<FeatureModel> {
    private static Logger logger = Logger.getLogger(EMFFeatureModelBuilder.class);

    public FeatureModelWrapper<FeatureModel> build(VariationPointModel vpm, String rootFeatureName) {
        FeatureModel fm = this.initFeatureModel(vpm, rootFeatureName);
        for (VariationPointGroup variationPointGroup : vpm.getVariationPointGroups()) {
            Feature vpFeature = this.createVariationPointGroupFeature(variationPointGroup, fm.getRoot());
            Group group = this.createMandatoryFeatureGroup();
            vpFeature.getChildren().add((Object)group);
            HashSet<String> variantIds = new HashSet<String>();
            VariabilityType variabilityType = null;
            for (VariationPoint variationPoint : variationPointGroup.getVariationPoints()) {
                if (variabilityType == null) {
                    variabilityType = variationPoint.getVariabilityType();
                }
                for (Variant variant : variationPoint.getVariants()) {
                    variantIds.add(variant.getId());
                }
            }
            for (String variantId : variantIds) {
                Feature vFeature = this.createVariantFeature(variantId);
                group.getFeatures().add((Object)vFeature);
            }
            this.setGroupCharacteristics(group, variantIds, variabilityType);
        }
        return new FeatureModelWrapper((Object)fm, true);
    }

    private void setGroupCharacteristics(Group group, Set<String> variantIds, VariabilityType variabilityType) {
        if (this.isOptional(variabilityType)) {
            group.setLower(0);
        } else {
            group.setLower(1);
        }
        if (this.isAlternative(variabilityType)) {
            group.setUpper(1);
        } else {
            group.setUpper(variantIds.size());
        }
    }

    private boolean isAlternative(VariabilityType variabilityType) {
        return variabilityType == VariabilityType.XOR || variabilityType == VariabilityType.OPTXOR;
    }

    private boolean isOptional(VariabilityType variabilityType) {
        return variabilityType == VariabilityType.OPTOR || variabilityType == VariabilityType.OPTXOR;
    }

    private Feature createVariantFeature(String variantId) {
        Feature feature = FeatureModelFactory.eINSTANCE.createFeature();
        feature.setName(variantId);
        feature.setId(EcoreUtil.generateUUID());
        return feature;
    }

    private Feature createVariationPointGroupFeature(VariationPointGroup variationPointGroup, Feature parentFeature) {
        Group group = this.createMandatoryFeatureGroup();
        parentFeature.getChildren().add((Object)group);
        Feature feature = FeatureModelFactory.eINSTANCE.createFeature();
        feature.setName(variationPointGroup.getName());
        feature.setId(EcoreUtil.generateUUID());
        group.getFeatures().add((Object)feature);
        return feature;
    }

    private Group createMandatoryFeatureGroup() {
        Group group = FeatureModelFactory.eINSTANCE.createGroup();
        group.setId(EcoreUtil.generateUUID());
        group.setLower(1);
        group.setUpper(1);
        return group;
    }

    private FeatureModel initFeatureModel(VariationPointModel vpm, String rootFeatureName) {
        FeatureModel fm = FeatureModelFactory.eINSTANCE.createFeatureModel();
        fm.setId(EcoreUtil.generateUUID());
        fm.setVersion("1.0");
        Feature rootFeature = FeatureModelFactory.eINSTANCE.createFeature();
        rootFeature.setName(rootFeatureName);
        rootFeature.setId(EcoreUtil.generateUUID());
        fm.setRoot(rootFeature);
        return fm;
    }

    public String getId() {
        return "org.splevo.fm.builder.emffeaturemodel.builder";
    }

    public String getLabel() {
        return "EMF Feature Model Builder";
    }

    public void save(FeatureModel featureModel, String targetDirectory) {
        String modelPath = String.valueOf(targetDirectory) + "feature-model.featuremodel";
        String diagramPath = String.valueOf(targetDirectory) + "feature-model." + "featurediagram";
        File file = new File(modelPath);
        URI featureModelURI = URI.createPlatformResourceURI((String)modelPath, (boolean)false);
        URI featureDiagramURI = URI.createPlatformResourceURI((String)diagramPath, (boolean)false);
        try {
            FeatureModelUtil.save(featureModel, file);
            FMEDiagramEditorUtil.createFeatureDiagram((URI)featureDiagramURI, (URI)featureModelURI, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            logger.error((Object)"Failed to save feature model", (Throwable)e);
        }
    }
}

