/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.algorithm.clones.baxtor.test;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.emftext.language.java.classifiers.AnonymousClass;
import org.emftext.language.java.classifiers.ClassifiersPackage;
import org.emftext.language.java.classifiers.Enumeration;
import org.emftext.language.java.commons.Commentable;
import org.emftext.language.java.commons.CommonsPackage;
import org.emftext.language.java.variables.VariablesPackage;
import org.emftext.language.java.variables.impl.LocalVariableImpl;
import org.emftext.language.java.variables.impl.VariableImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.splevo.jamopp.algorithm.clones.baxtor.CloneDetectionType;
import org.splevo.jamopp.algorithm.clones.baxtor.CloneDetector;

public class CloneDetectorTest {
    private CloneDetector structuralDetector;
    private CloneDetector exactDetector;

    @Before
    public void intialize() {
        this.structuralDetector = new CloneDetector(CloneDetectionType.STRUCTURAL);
        this.exactDetector = new CloneDetector(CloneDetectionType.EXACT);
    }

    @Test
    public void testIfAnyCommentableIsNullTheyAreNotClones() {
        Commentable commentable = (Commentable)Mockito.mock(Commentable.class);
        Mockito.when((Object)commentable.eClass()).thenReturn((Object)CommonsPackage.Literals.COMMENTABLE);
        boolean isClone = this.structuralDetector.isClone(null, commentable);
        Assert.assertThat((String)"If the first commentable is null", (Object)isClone, (Matcher)CoreMatchers.is((Object)false));
        isClone = this.structuralDetector.isClone(commentable, null);
        Assert.assertThat((String)"If the second commentable is null", (Object)isClone, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testSelfIsClone() {
        Commentable commentable = (Commentable)Mockito.mock(Commentable.class);
        Mockito.when((Object)commentable.eClass()).thenReturn((Object)CommonsPackage.Literals.COMMENTABLE);
        boolean isClone = this.structuralDetector.isClone(commentable, commentable);
        Assert.assertThat((String)"If both commentables are the same object", (Object)isClone, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testDifferentEClassesAreNotClone() {
        AnonymousClass anonClass = (AnonymousClass)Mockito.mock(AnonymousClass.class);
        Enumeration enummer = (Enumeration)Mockito.mock(Enumeration.class);
        Mockito.when((Object)anonClass.eClass()).thenReturn((Object)ClassifiersPackage.Literals.ANONYMOUS_CLASS);
        Mockito.when((Object)enummer.eClass()).thenReturn((Object)ClassifiersPackage.Literals.ENUMERATION);
        boolean isClone = this.structuralDetector.isClone((Commentable)anonClass, (Commentable)enummer);
        Assert.assertThat((String)"For commentables of different types", (Object)isClone, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testRenamedVariableIsStructuralClone() {
        VariableImpl variable1 = (VariableImpl)Mockito.mock(VariableImpl.class);
        VariableImpl variable2 = (VariableImpl)Mockito.mock(VariableImpl.class);
        Mockito.when((Object)variable1.eClass()).thenReturn((Object)VariablesPackage.Literals.VARIABLE);
        Mockito.when((Object)variable2.eClass()).thenReturn((Object)VariablesPackage.Literals.VARIABLE);
        TreeIterator iter = (TreeIterator)Mockito.mock(TreeIterator.class);
        Mockito.when((Object)iter.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)variable1.eAllContents()).thenReturn((Object)iter);
        Mockito.when((Object)variable2.eAllContents()).thenReturn((Object)iter);
        Mockito.when((Object)variable1.getName()).thenReturn((Object)"a");
        Mockito.when((Object)variable2.getName()).thenReturn((Object)"b");
        boolean isClone = this.structuralDetector.isClone((Commentable)variable1, (Commentable)variable2);
        Assert.assertThat((String)"For a renamed variable with a structural detector", (Object)isClone, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testVariableWithSameNameIsExactClone() {
        LocalVariableImpl variable1 = (LocalVariableImpl)Mockito.mock(LocalVariableImpl.class);
        LocalVariableImpl variable2 = (LocalVariableImpl)Mockito.mock(LocalVariableImpl.class);
        TreeIterator iter = (TreeIterator)Mockito.mock(TreeIterator.class);
        Mockito.when((Object)iter.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)variable1.eAllContents()).thenReturn((Object)iter);
        Mockito.when((Object)variable2.eAllContents()).thenReturn((Object)iter);
        Mockito.when((Object)variable1.eClass()).thenReturn((Object)VariablesPackage.Literals.LOCAL_VARIABLE);
        Mockito.when((Object)variable2.eClass()).thenReturn((Object)VariablesPackage.Literals.LOCAL_VARIABLE);
        Mockito.when((Object)variable1.getName()).thenReturn((Object)"a");
        Mockito.when((Object)variable2.getName()).thenReturn((Object)"a");
        boolean isClone = this.exactDetector.isClone((Commentable)variable1, (Commentable)variable2);
        Assert.assertThat((String)"For a renamed variable with an excact detector", (Object)isClone, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testRenamedVariableIsNoExactClone() {
        LocalVariableImpl variable1 = (LocalVariableImpl)Mockito.mock(LocalVariableImpl.class);
        LocalVariableImpl variable2 = (LocalVariableImpl)Mockito.mock(LocalVariableImpl.class);
        TreeIterator iter = (TreeIterator)Mockito.mock(TreeIterator.class);
        Mockito.when((Object)iter.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)variable1.eAllContents()).thenReturn((Object)iter);
        Mockito.when((Object)variable2.eAllContents()).thenReturn((Object)iter);
        Mockito.when((Object)variable1.eClass()).thenReturn((Object)VariablesPackage.Literals.LOCAL_VARIABLE);
        Mockito.when((Object)variable2.eClass()).thenReturn((Object)VariablesPackage.Literals.LOCAL_VARIABLE);
        Mockito.when((Object)variable1.getName()).thenReturn((Object)"a");
        Mockito.when((Object)variable2.getName()).thenReturn((Object)"b");
        boolean isClone = this.exactDetector.isClone((Commentable)variable1, (Commentable)variable2);
        Assert.assertThat((String)"For a renamed variable with an excact detector", (Object)isClone, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testNullParametersShouldThrowException() {
        List list = (List)Mockito.mock(List.class);
        boolean isClone = this.structuralDetector.isClone(null, list);
        Assert.assertThat((String)"For null values", (Object)isClone, (Matcher)CoreMatchers.is((Object)false));
        isClone = this.structuralDetector.isClone(list, null);
        Assert.assertThat((String)"For null values", (Object)isClone, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testListsOfSizeZeroAreNotClones() {
        List list1 = (List)Mockito.mock(List.class);
        List list2 = (List)Mockito.mock(List.class);
        Mockito.when((Object)list1.size()).thenReturn((Object)0);
        Mockito.when((Object)list2.size()).thenReturn((Object)1);
        boolean isClone = this.structuralDetector.isClone(list1, list2);
        Assert.assertThat((String)"If list1 size is 0", (Object)isClone, (Matcher)CoreMatchers.is((Object)false));
        isClone = this.structuralDetector.isClone(list2, list1);
        Assert.assertThat((String)"If list2 size is 0", (Object)isClone, (Matcher)CoreMatchers.is((Object)false));
        isClone = this.structuralDetector.isClone(list1, list1);
        Assert.assertThat((String)"If both lists size is 0", (Object)isClone, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testListsOfCommentablesOfDifferentSizesAreNotClones() {
        List list1 = (List)Mockito.mock(List.class);
        List list2 = (List)Mockito.mock(List.class);
        Mockito.when((Object)list1.size()).thenReturn((Object)1);
        Mockito.when((Object)list2.size()).thenReturn((Object)2);
        boolean isClone = this.structuralDetector.isClone(list1, list2);
        Assert.assertThat((String)"For lists of different length ", (Object)isClone, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testIdenticalListsOfCommentablesAreClones() {
        List list = (List)Mockito.mock(List.class);
        Iterator iter = (Iterator)Mockito.mock(Iterator.class);
        Commentable commentable = (Commentable)Mockito.mock(Commentable.class);
        Mockito.when((Object)list.size()).thenReturn((Object)1);
        Mockito.when(list.iterator()).thenReturn((Object)iter);
        Mockito.when((Object)iter.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)((Commentable)iter.next())).thenReturn((Object)commentable);
        Mockito.when((Object)commentable.eClass()).thenReturn((Object)CommonsPackage.Literals.COMMENTABLE);
        boolean isClone = this.structuralDetector.isClone(list, list);
        Assert.assertThat((String)"For two identical, nonempty lists of commenables", (Object)isClone, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testListsOfDifferentCommentablesAreNotClones() {
        List list1 = (List)Mockito.mock(List.class);
        List list2 = (List)Mockito.mock(List.class);
        Iterator iter1 = (Iterator)Mockito.mock(Iterator.class);
        Iterator iter2 = (Iterator)Mockito.mock(Iterator.class);
        AnonymousClass anonClass = (AnonymousClass)Mockito.mock(AnonymousClass.class);
        Enumeration enummer = (Enumeration)Mockito.mock(Enumeration.class);
        Mockito.when((Object)list1.size()).thenReturn((Object)1);
        Mockito.when((Object)list2.size()).thenReturn((Object)1);
        Mockito.when(list1.iterator()).thenReturn((Object)iter1);
        Mockito.when(list2.iterator()).thenReturn((Object)iter2);
        Mockito.when((Object)iter1.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)iter2.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)((Commentable)iter1.next())).thenReturn((Object)anonClass);
        Mockito.when((Object)((Commentable)iter2.next())).thenReturn((Object)enummer);
        Mockito.when((Object)anonClass.eClass()).thenReturn((Object)ClassifiersPackage.Literals.ANONYMOUS_CLASS);
        Mockito.when((Object)enummer.eClass()).thenReturn((Object)ClassifiersPackage.Literals.ENUMERATION);
        boolean isClone = this.structuralDetector.isClone(list1, list2);
        Assert.assertThat((String)"For two lists of different Commentables", (Object)isClone, (Matcher)CoreMatchers.is((Object)false));
    }
}

