/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing.edit.util;

import java.util.ArrayList;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.provider.DiffItemProvider;
import org.eclipse.emf.edit.provider.ComposedImage;

public class ImageUtil {
    private static final String OVERLAY_ICON_INSERT = "overlays/insert";
    private static final String OVERLAY_ICON_DELETE = "overlays/delete";
    private static final String OVERLAY_ICON_CHANGE = "overlays/change";

    public static Object composeImage(Object baseImage, DiffItemProvider itemProvider, String imagePath) {
        ArrayList<Object> images = new ArrayList<Object>(2);
        images.add(baseImage);
        images.add(itemProvider.getResourceLocator().getImage(imagePath));
        return new ComposedImage(images);
    }

    public static Object makeInsertIcon(Object baseImage, DiffItemProvider itemProvider) {
        return ImageUtil.composeImage(baseImage, itemProvider, OVERLAY_ICON_INSERT);
    }

    public static Object makeChangeIcon(Object baseImage, DiffItemProvider itemProvider) {
        return ImageUtil.composeImage(baseImage, itemProvider, OVERLAY_ICON_CHANGE);
    }

    public static Object makeDeleteIcon(Object baseImage, DiffItemProvider itemProvider) {
        return ImageUtil.composeImage(baseImage, itemProvider, OVERLAY_ICON_DELETE);
    }

    public static Object overlayChangeType(Object baseImage, Diff diff, DiffItemProvider itemProvider) {
        switch (diff.getKind()) {
            case ADD: {
                return ImageUtil.makeInsertIcon(baseImage, itemProvider);
            }
            case DELETE: {
                return ImageUtil.makeDeleteIcon(baseImage, itemProvider);
            }
        }
        return ImageUtil.makeChangeIcon(baseImage, itemProvider);
    }
}

