/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.emftext.language.java.commons.NamedElement;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.jamopp.diffing.JaMoPPDiffer;
import org.splevo.jamopp.diffing.TestUtil;
import org.splevo.jamopp.diffing.jamoppdiff.ImplementsChange;

public class ImplementsTest {
    private static final String BASE_PATH = "testmodels/implementation/ImplementsChange/";

    @BeforeClass
    public static void initTest() throws Exception {
        TestUtil.setUp();
    }

    @Test
    public void testClassImplements() throws Exception {
        ResourceSet setA = TestUtil.extractModel("testmodels/implementation/ImplementsChange/classimplements/a");
        ResourceSet setB = TestUtil.extractModel("testmodels/implementation/ImplementsChange/classimplements/b");
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Map<String, String> diffOptions = TestUtil.getDiffOptions();
        diffOptions.put("JaMoPP.Files.to.ignore", "");
        Comparison comparison = differ.doDiff(setA, setB, diffOptions);
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)4));
        for (Diff diffElement : differences) {
            if (diffElement instanceof ImplementsChange) {
                ImplementsChange implementsChange = (ImplementsChange)diffElement;
                NamedElement target = (NamedElement)implementsChange.getChangedReference().getTarget();
                if (implementsChange.getKind() == DifferenceKind.ADD) {
                    Assert.assertThat((Object)target.getName(), (Matcher)CoreMatchers.equalTo((Object)"InterfaceA"));
                    continue;
                }
                if (implementsChange.getKind() == DifferenceKind.DELETE) {
                    Assert.assertThat((Object)target.getName(), (Matcher)CoreMatchers.equalTo((Object)"InterfaceB"));
                    continue;
                }
                Assert.fail((String)("Unexpected Difference Kind: " + implementsChange.getKind()));
                continue;
            }
            Assert.fail((String)("No other diff elements than ExtendsChange should have been detected: " + diffElement));
        }
    }
}

