/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing;

import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.jamopp.diffing.JaMoPPDiffer;
import org.splevo.jamopp.diffing.TestUtil;
import org.splevo.jamopp.diffing.jamoppdiff.StatementChange;

public class MethodCallTest {
    private static final String BASE_PATH = "testmodels/implementation/methodcalls/";
    private Logger logger = Logger.getLogger(MethodCallTest.class);
    private static ResourceSet setA;
    private static ResourceSet setB;

    @BeforeClass
    public static void initTest() throws Exception {
        TestUtil.setUp();
        setA = TestUtil.extractModel("testmodels/implementation/methodcalls/a");
        setB = TestUtil.extractModel("testmodels/implementation/methodcalls/b");
    }

    @Test
    public void testDoDiff() throws Exception {
        TestUtil.setUp();
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Map<String, String> diffOptions = TestUtil.getDiffOptions();
        Comparison comparison = differ.doDiff(setA, setB, diffOptions);
        EList differences = comparison.getDifferences();
        for (Diff diffElement : differences) {
            this.logger.debug((Object)diffElement.getClass().getSimpleName());
            if (!(diffElement instanceof StatementChange)) continue;
            StatementChange change = (StatementChange)diffElement;
            this.logger.debug((Object)TestUtil.printDiff((Diff)change));
        }
        Assert.assertThat((String)"Exactly one change should exist", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)1));
        Diff diff = (Diff)differences.get(0);
        Assert.assertThat((Object)diff, (Matcher)CoreMatchers.instanceOf(StatementChange.class));
    }
}

