/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing;

import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.jamopp.diffing.JaMoPPDiffer;
import org.splevo.jamopp.diffing.TestUtil;
import org.splevo.jamopp.diffing.jamoppdiff.CompilationUnitChange;

public class SimilarClassesDifferentPackagesTest {
    private static final String BASE_PATH = "testmodels/implementation/similarclasses-differentpackages/";
    private Logger logger = Logger.getLogger(SimilarClassesDifferentPackagesTest.class);
    private static ResourceSet setA;
    private static ResourceSet setB;

    @BeforeClass
    public static void initTest() throws Exception {
        TestUtil.setUp();
        setA = TestUtil.extractModel("testmodels/implementation/similarclasses-differentpackages/a");
        setB = TestUtil.extractModel("testmodels/implementation/similarclasses-differentpackages/b");
    }

    @Test
    public void testDoDiff() throws Exception {
        TestUtil.setUp();
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Map<String, String> diffOptions = TestUtil.getDiffOptions();
        Comparison comparison = differ.doDiff(setA, setB, diffOptions);
        Assert.assertThat((String)"Wrong number of matched resources", (Object)comparison.getMatchedResources().size(), (Matcher)CoreMatchers.is((Object)2));
        EList differences = comparison.getDifferences();
        for (Diff diffElement : differences) {
            this.logger.debug((Object)diffElement.getClass().getSimpleName());
            if (!(diffElement instanceof CompilationUnitChange)) continue;
            CompilationUnitChange change = (CompilationUnitChange)diffElement;
            this.logger.debug((Object)change.getChangedCompilationUnit().getName());
        }
        Assert.assertThat((String)"No difference should exist", (Object)comparison.getMatches().size(), (Matcher)CoreMatchers.is((Object)0));
    }
}

