/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing;

import com.google.common.collect.Sets;
import java.io.File;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.emftext.language.java.imports.ClassifierImport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.splevo.jamopp.diffing.JaMoPPDiffer;
import org.splevo.jamopp.diffing.TestUtil;
import org.splevo.jamopp.diffing.jamoppdiff.ImportChange;

public class ImportChangeDiffingTest {
    private Logger logger = Logger.getLogger(ImportChangeDiffingTest.class);
    private String basePath = "testmodels/implementation/import/";

    @Test
    public void testDoDiff() throws Exception {
        TestUtil.setUp();
        File testFileA = new File(String.valueOf(this.basePath) + "a/ImportDiffing.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/ImportDiffing.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        for (Diff diff : differences) {
            this.logger.debug((Object)(diff.getKind() + ": " + TestUtil.printDiff(diff)));
        }
        Assert.assertThat((String)"Wrong number of differences detected", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((String)"Wrong change kind", (Object)((Diff)differences.get(0)).getKind(), (Matcher)CoreMatchers.is((Object)DifferenceKind.ADD));
        ImportChange change0 = (ImportChange)differences.get(0);
        ClassifierImport import0 = (ClassifierImport)change0.getChangedImport();
        String class0 = import0.getClassifier().getName();
        Assert.assertThat((String)"BigDecimal should have been recognized as new import", (Object)class0, (Matcher)CoreMatchers.equalTo((Object)"BigDecimal"));
        Assert.assertThat((String)"Wrong change kind", (Object)((Diff)differences.get(1)).getKind(), (Matcher)CoreMatchers.is((Object)DifferenceKind.DELETE));
        ImportChange change1 = (ImportChange)differences.get(1);
        ClassifierImport import1 = (ClassifierImport)change1.getChangedImport();
        String class1 = import1.getClassifier().getName();
        Assert.assertThat((String)"BigInteger should have been recognized as new import", (Object)class1, (Matcher)CoreMatchers.equalTo((Object)"BigInteger"));
    }
}

