/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.emftext.language.java.commons.Commentable;
import org.emftext.language.java.members.ClassMethod;
import org.emftext.language.java.statements.Statement;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.jamopp.diffing.JaMoPPDiffer;
import org.splevo.jamopp.diffing.TestUtil;
import org.splevo.jamopp.diffing.jamoppdiff.StatementChange;
import org.splevo.jamopp.diffing.similarity.SimilarityChecker;

public class JaMoPPElementComparisonTest {
    private static final String BASE_PATH = "testmodels/implementation/JaMoPPElementComparison/";

    @BeforeClass
    public static void setUp() {
        TestUtil.setUp();
    }

    @Test
    public void testMethodsWithChangedBody() throws Exception {
        TestUtil.setUp();
        ResourceSet setA = TestUtil.extractModel("testmodels/implementation/JaMoPPElementComparison/MethodsWithChangedBody/a");
        ResourceSet setB = TestUtil.extractModel("testmodels/implementation/JaMoPPElementComparison/MethodsWithChangedBody/b");
        ClassMethod methodA = this.searchMethodElement(setA);
        ClassMethod methodB = this.searchMethodElement(setB);
        JaMoPPDiffer differ = new JaMoPPDiffer();
        HashMap diffOptions = Maps.newHashMap();
        Comparison comparison = differ.doDiff((Commentable)methodA, (Commentable)methodB, (Map)diffOptions);
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Exactly one change should exist", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)1));
        Diff diff = (Diff)differences.get(0);
        Assert.assertThat((Object)diff, (Matcher)CoreMatchers.instanceOf(StatementChange.class));
    }

    @Test
    public void testNotMatchingStatements() throws Exception {
        ResourceSet setA = TestUtil.extractModel("testmodels/implementation/JaMoPPElementComparison/NotMatchingStatements/a");
        ResourceSet setB = TestUtil.extractModel("testmodels/implementation/JaMoPPElementComparison/NotMatchingStatements/b");
        ClassMethod methodA = this.searchMethodElement(setA);
        ClassMethod methodB = this.searchMethodElement(setB);
        Statement statementA = (Statement)methodA.getStatements().get(0);
        Statement statementB = (Statement)methodB.getStatements().get(0);
        JaMoPPDiffer differ = new JaMoPPDiffer();
        HashMap diffOptions = Maps.newHashMap();
        Comparison comparison = differ.doDiff((Commentable)statementA, (Commentable)statementB, (Map)diffOptions);
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Exactly two changes should exist", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)2));
        Diff diff1 = (Diff)differences.get(0);
        Assert.assertThat((Object)diff1, (Matcher)CoreMatchers.instanceOf(StatementChange.class));
        Diff diff2 = (Diff)differences.get(1);
        Assert.assertThat((Object)diff2, (Matcher)CoreMatchers.instanceOf(StatementChange.class));
    }

    @Test
    public void testMatchWithDifferentNeighbors() throws Exception {
        ResourceSet setA = TestUtil.extractModel("testmodels/implementation/JaMoPPElementComparison/MatchWithDifferentNeighbors/a");
        ResourceSet setB = TestUtil.extractModel("testmodels/implementation/JaMoPPElementComparison/MatchWithDifferentNeighbors/b");
        ClassMethod methodA = this.searchMethodElement(setA);
        ClassMethod methodB = this.searchMethodElement(setB);
        Statement statementA = (Statement)methodA.getStatements().get(0);
        Statement statementB = (Statement)methodB.getStatements().get(1);
        SimilarityChecker checker = new SimilarityChecker();
        Boolean similar = checker.isSimilar((EObject)statementA, (EObject)statementB, false);
        Assert.assertThat((Object)similar, (Matcher)CoreMatchers.is((Object)true));
    }

    private ClassMethod searchMethodElement(ResourceSet resourceSet) {
        Resource resource = (Resource)resourceSet.getResources().get(0);
        TreeIterator contentIterator = resource.getAllContents();
        ClassMethod methodUnderTest = null;
        while (contentIterator.hasNext()) {
            EObject next = (EObject)contentIterator.next();
            if (!(next instanceof ClassMethod)) continue;
            methodUnderTest = (ClassMethod)next;
            break;
        }
        return methodUnderTest;
    }
}

