/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.emftext.language.java.JavaClasspath;
import org.emftext.language.java.JavaPackage;
import org.emftext.language.java.resource.JavaSourceOrClassFileResourceFactoryImpl;
import org.emftext.language.java.resource.java.IJavaTextResource;
import org.emftext.language.java.resource.java.mopp.JavaPrinter2;
import org.emftext.language.java.resource.java.mopp.JavaResource;
import org.emftext.language.java.statements.Statement;
import org.junit.BeforeClass;
import org.splevo.commons.emf.SPLevoResourceSet;
import org.splevo.extraction.SoftwareModelExtractionException;
import org.splevo.jamopp.diffing.jamoppdiff.ClassChange;
import org.splevo.jamopp.diffing.jamoppdiff.CompilationUnitChange;
import org.splevo.jamopp.diffing.jamoppdiff.ImportChange;
import org.splevo.jamopp.diffing.jamoppdiff.StatementChange;
import org.splevo.jamopp.extraction.JaMoPPSoftwareModelExtractor;

public abstract class TestUtil {
    private static Logger logger = Logger.getLogger(TestUtil.class);

    public static final Map<String, String> getDiffOptions() {
        LinkedHashMap<String, String> diffOptions = new LinkedHashMap<String, String>();
        StringBuilder builder = new StringBuilder();
        builder.append("java.*");
        builder.append(System.getProperty("line.separator"));
        builder.append("org.jscience.*");
        builder.append(System.getProperty("line.separator"));
        builder.append("javolution.*");
        diffOptions.put("JaMoPP.Java.Packages.to.ignore", builder.toString());
        return diffOptions;
    }

    @BeforeClass
    public static void setUp() {
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
    }

    public static ResourceSet extractModel(String path) throws SoftwareModelExtractionException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        String pathA = new File(path).getAbsolutePath();
        ArrayList urisA = Lists.newArrayList((Object[])new String[]{pathA});
        JaMoPPSoftwareModelExtractor extractor = new JaMoPPSoftwareModelExtractor();
        return extractor.extractSoftwareModel((List)urisA, (IProgressMonitor)monitor, null);
    }

    public static void save(Comparison comparisonModel, String relativeFilePath) throws IOException {
        String fileExtension = TestUtil.getFileExtension(relativeFilePath);
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put(fileExtension, new XMIResourceFactoryImpl());
        SPLevoResourceSet resSet = new SPLevoResourceSet();
        Resource resource = resSet.createResource(URI.createFileURI((String)relativeFilePath));
        resource.getContents().add((Object)comparisonModel);
        resource.save(Collections.EMPTY_MAP);
    }

    public static String printDiff(Diff diff) {
        StatementChange change;
        Statement changedElement = null;
        if (diff instanceof StatementChange) {
            change = (StatementChange)diff;
            changedElement = change.getChangedStatement();
        } else if (diff instanceof ImportChange) {
            change = (ImportChange)diff;
            changedElement = change.getChangedImport();
        } else if (diff instanceof CompilationUnitChange) {
            change = (CompilationUnitChange)diff;
            changedElement = change.getChangedCompilationUnit();
        } else if (diff instanceof ClassChange) {
            change = (ClassChange)diff;
            changedElement = change.getChangedClass();
        } else {
            logger.warn((Object)("Unexpected diff class" + diff.getClass().getSimpleName()));
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JavaPrinter2 printer = new JavaPrinter2((OutputStream)stream, (IJavaTextResource)new JavaResource());
        try {
            printer.print((EObject)changedElement);
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to print: ", (Throwable)e);
        }
        return stream.toString();
    }

    private static String getFileExtension(String path) {
        if (path == null) {
            return null;
        }
        String fileExtension = path.substring(path.lastIndexOf(46) + 1);
        return fileExtension;
    }

    public static ResourceSet loadResourceSet(Set<File> sourceFiles) throws IOException {
        ResourceSet rs = TestUtil.setUpResourceSet();
        JavaClasspath.get((ResourceSet)rs);
        for (File sourceFile : sourceFiles) {
            TestUtil.parseResource(sourceFile, rs);
        }
        if (!TestUtil.resolveAllProxies(0, rs)) {
            TestUtil.handleFailedProxyResolution(rs);
        }
        return rs;
    }

    private static void handleFailedProxyResolution(ResourceSet rs) {
        TreeIterator it = rs.getAllContents();
        while (it.hasNext()) {
            EObject o;
            Notifier next = (Notifier)it.next();
            if (!(next instanceof EObject) || !(o = (EObject)next).eIsProxy()) continue;
            try {
                it.remove();
            }
            catch (UnsupportedOperationException e) {
                e.printStackTrace();
                logger.info((Object)"Error during unresolved proxy handling", (Throwable)e);
            }
        }
    }

    private static boolean resolveAllProxies(int resourcesProcessedBefore, ResourceSet rs) {
        boolean failure = false;
        LinkedList<EObject> eobjects = new LinkedList<EObject>();
        TreeIterator i = rs.getAllContents();
        while (i.hasNext()) {
            Notifier notifier = (Notifier)i.next();
            if (!(notifier instanceof EObject)) continue;
            eobjects.add((EObject)notifier);
        }
        int resourcesProcessed = rs.getResources().size();
        if (resourcesProcessed == resourcesProcessedBefore) {
            return true;
        }
        for (EObject eObject : eobjects) {
            InternalEObject nextElement = (InternalEObject)eObject;
            for (EObject crElement : nextElement.eCrossReferences()) {
                if (!(crElement = EcoreUtil.resolve((EObject)crElement, (ResourceSet)rs)).eIsProxy()) continue;
                failure = true;
            }
        }
        return !failure && TestUtil.resolveAllProxies(resourcesProcessed, rs);
    }

    private static void parseResource(File file, ResourceSet rs) throws IOException {
        TestUtil.loadResource(file.getCanonicalPath(), rs);
    }

    private static void loadResource(String filePath, ResourceSet rs) throws IOException {
        TestUtil.loadResource(URI.createFileURI((String)filePath), rs);
    }

    private static void loadResource(URI uri, ResourceSet rs) throws IOException {
        rs.getResource(uri, true);
    }

    private static ResourceSet setUpResourceSet() {
        SPLevoResourceSet rs = new SPLevoResourceSet();
        rs.getLoadOptions().put("DISABLE_LAYOUT_INFORMATION_RECORDING", Boolean.FALSE);
        rs.getLoadOptions().put("DISABLE_LOCATION_MAP", Boolean.FALSE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.emftext.org/java", (Object)JavaPackage.eINSTANCE);
        Map extensionToFactoryMap = rs.getResourceFactoryRegistry().getExtensionToFactoryMap();
        extensionToFactoryMap.put("java", new JavaSourceOrClassFileResourceFactoryImpl());
        extensionToFactoryMap.put("*", new XMIResourceFactoryImpl());
        return rs;
    }
}

