/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing;

import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.emftext.language.java.classifiers.Class;
import org.emftext.language.java.classifiers.Enumeration;
import org.emftext.language.java.containers.CompilationUnit;
import org.emftext.language.java.containers.Package;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.jamopp.diffing.JaMoPPDiffer;
import org.splevo.jamopp.diffing.TestUtil;
import org.splevo.jamopp.diffing.jamoppdiff.ClassChange;
import org.splevo.jamopp.diffing.jamoppdiff.CompilationUnitChange;
import org.splevo.jamopp.diffing.jamoppdiff.EnumChange;
import org.splevo.jamopp.diffing.jamoppdiff.PackageChange;

public class ClassDeclarationTest {
    private static final String BASE_PATH = "testmodels/implementation/classdeclaration/";
    private Logger logger = Logger.getLogger(ClassDeclarationTest.class);
    private static ResourceSet setA;
    private static ResourceSet setB;

    @BeforeClass
    public static void initTest() throws Exception {
        TestUtil.setUp();
        setA = TestUtil.extractModel("testmodels/implementation/classdeclaration/a");
        setB = TestUtil.extractModel("testmodels/implementation/classdeclaration/b");
    }

    @Test
    public void testDoDiff() throws Exception {
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Map<String, String> diffOptions = TestUtil.getDiffOptions();
        diffOptions.put("JaMoPP.Files.to.ignore", "");
        Comparison comparison = differ.doDiff(setA, setB, diffOptions);
        EList differences = comparison.getDifferences();
        for (Diff diffElement : differences) {
            this.logger.debug((Object)(diffElement.getKind() + " | " + diffElement.getClass().getSimpleName() + " | " + diffElement.getMatch().getLeft()));
        }
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)6));
        for (Diff diffElement : differences) {
            if (diffElement instanceof ClassChange) {
                ClassChange classChange = (ClassChange)diffElement;
                Class classDecl = classChange.getChangedClass();
                Assert.assertEquals((String)"Wrong class detected as top level insert diff", (Object)"AddedClassDeclaration", (Object)classDecl.getName());
                continue;
            }
            if (diffElement instanceof EnumChange) {
                EnumChange enumChange = (EnumChange)diffElement;
                Enumeration enumLeft = enumChange.getChangedEnum();
                Assert.assertEquals((String)"Wrong enum detected as changed", (Object)"EnumChange", (Object)enumLeft.getName());
                Assert.assertEquals((String)"Wrong number of constants in enum", (long)3L, (long)enumLeft.getConstants().size());
                continue;
            }
            if (diffElement instanceof CompilationUnitChange) {
                CompilationUnitChange unitChange = (CompilationUnitChange)diffElement;
                CompilationUnit unit = unitChange.getChangedCompilationUnit();
                Assert.assertThat((String)"wrong difference type", (Object)unitChange.getKind(), (Matcher)CoreMatchers.equalTo((Object)DifferenceKind.ADD));
                Assert.assertThat((String)"Unexpected package added", (Object)unit.getName(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.equalTo((Object)"org.splevo.tests.fielddeclaration.AddedClassDeclaration.java"), (Matcher)CoreMatchers.equalTo((Object)"org.splevo.tests.fielddeclaration.newpackage.NewPackageClass.java"), (Matcher)CoreMatchers.equalTo((Object)"org.splevo.tests.fielddeclaration.newpackage.sub.NewSubPackageClass.java")));
                continue;
            }
            if (diffElement instanceof PackageChange) {
                PackageChange packageChange = (PackageChange)diffElement;
                Package packageDeclaration = packageChange.getChangedPackage();
                Assert.assertThat((String)"wrong difference type", (Object)packageChange.getKind(), (Matcher)CoreMatchers.equalTo((Object)DifferenceKind.ADD));
                Assert.assertThat((String)"Unexpected package added", (Object)packageDeclaration.getName(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.equalTo((Object)"newpackage"), (Matcher)CoreMatchers.equalTo((Object)"sub")));
                continue;
            }
            Assert.fail((String)("No other diff elements than class and package should have been detected: " + diffElement));
        }
    }

    @Test
    public void testDoDiffReverse() throws Exception {
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Map<String, String> diffOptions = TestUtil.getDiffOptions();
        diffOptions.put("JaMoPP.Files.to.ignore", "");
        Comparison comparison = differ.doDiff(setB, setA, diffOptions);
        EList differences = comparison.getDifferences();
        for (Diff diffElement : differences) {
            this.logger.debug((Object)diffElement.getClass().getSimpleName());
        }
        for (Diff diffElement : comparison.getDifferences()) {
            if (diffElement instanceof ClassChange) {
                ClassChange classChange = (ClassChange)diffElement;
                Class classDecl = classChange.getChangedClass();
                Assert.assertEquals((String)"Wrong class detected as top level insert diff", (Object)"AddedClassDeclaration", (Object)classDecl.getName());
                Assert.assertTrue((String)"ClassChange is not of type add", (classChange.getKind() == DifferenceKind.DELETE ? 1 : 0) != 0);
                continue;
            }
            if (diffElement instanceof EnumChange) {
                EnumChange enumChange = (EnumChange)diffElement;
                Enumeration enumLeft = enumChange.getChangedEnum();
                Assert.assertEquals((String)"Wrong enum detected as changed", (Object)"EnumChange", (Object)enumLeft.getName());
                Assert.assertEquals((String)"Wrong number of constants in enum", (long)2L, (long)enumLeft.getConstants().size());
                continue;
            }
            if (diffElement instanceof CompilationUnitChange) {
                CompilationUnitChange unitChange = (CompilationUnitChange)diffElement;
                CompilationUnit unit = unitChange.getChangedCompilationUnit();
                Assert.assertThat((String)"wrong difference type", (Object)unitChange.getKind(), (Matcher)CoreMatchers.equalTo((Object)DifferenceKind.DELETE));
                Assert.assertThat((String)"Unexpected package added", (Object)unit.getName(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.equalTo((Object)"org.splevo.tests.fielddeclaration.AddedClassDeclaration.java"), (Matcher)CoreMatchers.equalTo((Object)"org.splevo.tests.fielddeclaration.newpackage.NewPackageClass.java"), (Matcher)CoreMatchers.equalTo((Object)"org.splevo.tests.fielddeclaration.newpackage.sub.NewSubPackageClass.java")));
                continue;
            }
            if (diffElement instanceof PackageChange) {
                PackageChange packageChange = (PackageChange)diffElement;
                Package packageDeclaration = packageChange.getChangedPackage();
                Assert.assertThat((String)"wrong difference type", (Object)packageChange.getKind(), (Matcher)CoreMatchers.equalTo((Object)DifferenceKind.DELETE));
                Assert.assertThat((String)"Unexpected package deleted", (Object)packageDeclaration.getName(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.equalTo((Object)"newpackage"), (Matcher)CoreMatchers.equalTo((Object)"sub")));
                continue;
            }
            this.logger.error((Object)("Detected Diff: " + diffElement.getClass()));
            Assert.fail((String)"No other diff elements than class and package delete should have been detected.");
        }
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)6));
    }
}

