/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing;

import com.google.common.collect.Sets;
import java.io.File;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.emftext.language.java.members.Constructor;
import org.emftext.language.java.members.Method;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.splevo.jamopp.diffing.JaMoPPDiffer;
import org.splevo.jamopp.diffing.TestUtil;
import org.splevo.jamopp.diffing.jamoppdiff.ConstructorChange;
import org.splevo.jamopp.diffing.jamoppdiff.MethodChange;

public class MethodDeclarationTest {
    private static final String BASE_PATH = "testmodels/implementation/methoddeclaration/";

    @Test
    public void testDoDiff() throws Exception {
        TestUtil.setUp();
        File testFileA = new File("testmodels/implementation/methoddeclaration/a/ClassA.java");
        File testFileB = new File("testmodels/implementation/methoddeclaration/b/ClassA.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences detected", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Wrong change type", (Object)((Diff)differences.get(0)), (Matcher)CoreMatchers.instanceOf(MethodChange.class));
        MethodChange methodChange = (MethodChange)differences.get(0);
        Assert.assertThat((String)"Wrong DifferenceKind", (Object)methodChange.getKind(), (Matcher)CoreMatchers.is((Object)DifferenceKind.ADD));
        Method method = methodChange.getChangedMethod();
        Assert.assertThat((String)"Wrong method", (Object)method.getName(), (Matcher)CoreMatchers.is((Object)"newMethod"));
    }

    @Test
    public void testConstructorDiff() throws Exception {
        TestUtil.setUp();
        File testFileA = new File("testmodels/implementation/methoddeclaration/a/Constructor.java");
        File testFileB = new File("testmodels/implementation/methoddeclaration/b/Constructor.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences detected", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)2));
        for (Diff diff : differences) {
            Assert.assertThat((String)"Wrong change type", (Object)diff, (Matcher)CoreMatchers.instanceOf(ConstructorChange.class));
            ConstructorChange change = (ConstructorChange)differences.get(0);
            Constructor constructor = change.getChangedConstructor();
            EList params = constructor.getParameters();
            if (change.getKind() == DifferenceKind.ADD) {
                Assert.assertThat((String)"Wrong number of differences detected", (Object)params.size(), (Matcher)CoreMatchers.is((Object)1));
                continue;
            }
            if (change.getKind() == DifferenceKind.DELETE) {
                Assert.assertThat((String)"Wrong number of differences detected", (Object)params.size(), (Matcher)CoreMatchers.is((Object)0));
                continue;
            }
            Assert.fail((String)("Unexpected diff kind " + change.getKind()));
        }
    }
}

