/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing;

import com.google.common.collect.Sets;
import java.io.File;
import java.math.BigInteger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.emftext.language.java.expressions.AssignmentExpression;
import org.emftext.language.java.expressions.EqualityExpression;
import org.emftext.language.java.instantiations.NewConstructorCall;
import org.emftext.language.java.literals.DecimalIntegerLiteral;
import org.emftext.language.java.references.MethodCall;
import org.emftext.language.java.references.StringReference;
import org.emftext.language.java.resource.JavaSourceOrClassFileResource;
import org.emftext.language.java.statements.Block;
import org.emftext.language.java.statements.Condition;
import org.emftext.language.java.statements.ExpressionStatement;
import org.emftext.language.java.statements.Return;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.jamopp.diffing.JaMoPPDiffer;
import org.splevo.jamopp.diffing.TestUtil;
import org.splevo.jamopp.diffing.jamoppdiff.StatementChange;

public class StatementTest {
    private String basePath = "testmodels/implementation/statements/";

    @BeforeClass
    public static void setUp() {
        TestUtil.setUp();
    }

    @Test
    public void testArrayAccessesDiff() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/ArrayAccesses.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/ArrayAccesses.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testArrayItemAccessesDiff() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/ArrayItemAccess.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/ArrayItemAccess.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)1));
        StatementChange change = (StatementChange)differences.get(0);
        ExpressionStatement statement = (ExpressionStatement)change.getChangedStatement();
        AssignmentExpression exp = (AssignmentExpression)statement.getExpression();
        NewConstructorCall call = (NewConstructorCall)exp.getValue();
        StringReference stringRef = (StringReference)call.getArguments().get(0);
        Assert.assertThat((Object)stringRef.getValue(), (Matcher)CoreMatchers.equalTo((Object)"3"));
    }

    @Test
    public void testArrayItemAccessWithSameContainerIdentifierDiff() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/ArrayItemAccessWithSameContainerIdentifier.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/ArrayItemAccessWithSameContainerIdentifier.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testEnumAccessesDiff() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/EnumAccesses.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/EnumAccesses.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testClassStatementInsertDiff() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/ClassStatementInsert.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/ClassStatementInsert.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)7));
    }

    @Test
    public void testSynchronizedDiff() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/Synchronized.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/Synchronized.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testIfStatementDiff() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/IfStatements.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/IfStatements.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void testConditionMatchRelationExpression() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/ConditionMatchRelationExpression.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/ConditionMatchRelationExpression.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Wrong number of differences", (Object)((Diff)differences.get(0)).getKind(), (Matcher)CoreMatchers.is((Object)DifferenceKind.ADD));
        Condition cond = (Condition)((StatementChange)differences.get(0)).getChangedStatement();
        Return returnStmnt = (Return)((Block)cond.getStatement()).getStatements().get(0);
        StringReference returnValue = (StringReference)returnStmnt.getReturnValue();
        Assert.assertThat((String)"Wrong condition detected in change", (Object)returnValue.getValue(), (Matcher)CoreMatchers.equalTo((Object)"new conditional"));
    }

    @Test
    public void testConditionMatchAndExpression() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/ConditionMatchAndExpression.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/ConditionMatchAndExpression.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Wrong number of differences", (Object)((Diff)differences.get(0)).getKind(), (Matcher)CoreMatchers.is((Object)DifferenceKind.ADD));
        Condition cond = (Condition)((StatementChange)differences.get(0)).getChangedStatement();
        Return returnStmnt = (Return)((Block)cond.getStatement()).getStatements().get(0);
        StringReference returnValue = (StringReference)returnStmnt.getReturnValue();
        Assert.assertThat((String)"Wrong condition detected in change", (Object)returnValue.getValue(), (Matcher)CoreMatchers.equalTo((Object)"new conditional"));
    }

    @Test
    public void testConditionMatchUnaryExpression() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/ConditionMatchUnaryExpression.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/ConditionMatchUnaryExpression.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Wrong number of differences", (Object)((Diff)differences.get(0)).getKind(), (Matcher)CoreMatchers.is((Object)DifferenceKind.ADD));
        Condition cond = (Condition)((StatementChange)differences.get(0)).getChangedStatement();
        Return returnStmnt = (Return)((Block)cond.getStatement()).getStatements().get(0);
        StringReference returnValue = (StringReference)returnStmnt.getReturnValue();
        Assert.assertThat((String)"Wrong condition detected in change", (Object)returnValue.getValue(), (Matcher)CoreMatchers.equalTo((Object)"new unary conditional"));
    }

    @Test
    public void testConditionMatchInstanceOfExpression() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/ConditionMatchInstanceOfExpression.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/ConditionMatchInstanceOfExpression.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Wrong number of differences", (Object)((Diff)differences.get(0)).getKind(), (Matcher)CoreMatchers.is((Object)DifferenceKind.ADD));
        Condition cond = (Condition)((StatementChange)differences.get(0)).getChangedStatement();
        Return returnStmnt = (Return)((Block)cond.getStatement()).getStatements().get(0);
        StringReference returnValue = (StringReference)returnStmnt.getReturnValue();
        Assert.assertThat((String)"Wrong condition detected in change", (Object)returnValue.getValue(), (Matcher)CoreMatchers.equalTo((Object)"new instanceof conditional"));
    }

    @Test
    public void testConditionMatchOrExpression() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/ConditionMatchOrExpression.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/ConditionMatchOrExpression.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Wrong number of differences", (Object)((Diff)differences.get(0)).getKind(), (Matcher)CoreMatchers.is((Object)DifferenceKind.ADD));
        Condition cond = (Condition)((StatementChange)differences.get(0)).getChangedStatement();
        Return returnStmnt = (Return)((Block)cond.getStatement()).getStatements().get(0);
        StringReference returnValue = (StringReference)returnStmnt.getReturnValue();
        Assert.assertThat((String)"Wrong condition detected in change", (Object)returnValue.getValue(), (Matcher)CoreMatchers.equalTo((Object)"new conditional"));
    }

    @Test
    public void testIfElseStatementDiff() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/IfElseStatements.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/IfElseStatements.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)2));
        for (Diff diff : differences) {
            Assert.assertThat((String)"StatementChange expected", (Object)diff, (Matcher)CoreMatchers.instanceOf(StatementChange.class));
            StatementChange stmtChange = (StatementChange)diff;
            Assert.assertThat((String)"Wrong changed statement type", (Object)stmtChange.getChangedStatement(), (Matcher)CoreMatchers.instanceOf(Condition.class));
            Condition condition = (Condition)stmtChange.getChangedStatement();
            EqualityExpression exp = (EqualityExpression)condition.getCondition();
            DecimalIntegerLiteral value = (DecimalIntegerLiteral)exp.getChildren().get(1);
            if (diff.getKind() == DifferenceKind.ADD) {
                Assert.assertThat((String)"Wrong condition for add", (Object)value.getDecimalValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)BigInteger.valueOf(54L))));
                continue;
            }
            if (diff.getKind() == DifferenceKind.DELETE) {
                Assert.assertThat((String)"Wrong condition for add", (Object)value.getDecimalValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)BigInteger.valueOf(2L))));
                continue;
            }
            Assert.fail((String)("Unexpected condition value: " + value));
        }
    }

    @Test
    public void testIfIfStatementDiff() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/IfIfStatements.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/IfIfStatements.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)1));
        Diff diff = (Diff)differences.get(0);
        Assert.assertThat((String)"StatementChange expected", (Object)diff, (Matcher)CoreMatchers.instanceOf(StatementChange.class));
        StatementChange stmtChange = (StatementChange)diff;
        Assert.assertThat((String)"Wrong changed statement type", (Object)stmtChange.getChangedStatement(), (Matcher)CoreMatchers.instanceOf(Condition.class));
        Assert.assertThat((String)"Wrong difference type", (Object)stmtChange.getKind(), (Matcher)CoreMatchers.is((Object)DifferenceKind.ADD));
        Condition condition = (Condition)stmtChange.getChangedStatement();
        MethodCall call1 = (MethodCall)condition.getCondition();
        MethodCall call2 = (MethodCall)call1.getNext();
        StringReference stringRef = (StringReference)call2.getArguments().get(0);
        Assert.assertThat((String)"wrong condition in changed Statement", (Object)stringRef.getValue(), (Matcher)CoreMatchers.is((Object)"b"));
    }

    @Test
    public void testIfElseMultipleStatementDiff() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/IfElseMultipleStatements.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/IfElseMultipleStatements.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)2));
        for (Diff diff : differences) {
            Assert.assertThat((String)"StatementChange expected", (Object)diff, (Matcher)CoreMatchers.instanceOf(StatementChange.class));
            StatementChange stmtChange = (StatementChange)diff;
            Assert.assertThat((String)"Wrong changed statement type", (Object)stmtChange.getChangedStatement(), (Matcher)CoreMatchers.instanceOf(Condition.class));
            Condition condition = (Condition)stmtChange.getChangedStatement();
            EqualityExpression exp = (EqualityExpression)condition.getCondition();
            DecimalIntegerLiteral value = (DecimalIntegerLiteral)exp.getChildren().get(1);
            if (diff.getKind() == DifferenceKind.ADD) {
                Assert.assertThat((String)"Wrong condition for add", (Object)value.getDecimalValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)BigInteger.valueOf(54L))));
                continue;
            }
            if (diff.getKind() == DifferenceKind.DELETE) {
                Assert.assertThat((String)"Wrong condition for add", (Object)value.getDecimalValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)BigInteger.valueOf(2L))));
                continue;
            }
            Assert.fail((String)("Unexpected condition value: " + value));
        }
    }

    @Test
    public void testForLoopWithIterator() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/ForLoopWithIterator.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/ForLoopWithIterator.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Should return no difference", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testLoopStatementDiff() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/LoopStatements.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/LoopStatements.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testChangeInsideSiblingBlockDiff() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/ChangeInsideSiblingBlock.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/ChangeInsideSiblingBlock.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JavaSourceOrClassFileResource resA = (JavaSourceOrClassFileResource)rsA.getResources().get(0);
        Assert.assertThat((String)("Errors during Extraction " + resA.getErrors()), (Object)resA.getErrors().size(), (Matcher)CoreMatchers.is((Object)0));
        JavaSourceOrClassFileResource resB = (JavaSourceOrClassFileResource)rsA.getResources().get(0);
        Assert.assertThat((String)("Errors during Extraction " + resB.getErrors()), (Object)resB.getErrors().size(), (Matcher)CoreMatchers.is((Object)0));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testReturnStatementsDiff() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/ReturnStatementChanges.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/ReturnStatementChanges.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void testThrowStatementsDiff() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/ThrowStatements.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/ThrowStatements.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testTryCatchDiff() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/TryCatch.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/TryCatch.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testVariableDeclarationDiff() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/VariableDeclarationStatements.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/VariableDeclarationStatements.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testStaticInitializationDiff() throws Exception {
        File testFileA = new File(String.valueOf(this.basePath) + "a/StaticInitialization.java");
        File testFileB = new File(String.valueOf(this.basePath) + "b/StaticInitialization.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)2));
    }
}

