/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing.diff;

import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ComposedSwitch;
import org.eclipse.emf.ecore.util.Switch;
import org.emftext.language.java.classifiers.Class;
import org.emftext.language.java.classifiers.Enumeration;
import org.emftext.language.java.classifiers.Interface;
import org.emftext.language.java.classifiers.util.ClassifiersSwitch;
import org.emftext.language.java.containers.CompilationUnit;
import org.emftext.language.java.containers.Package;
import org.emftext.language.java.containers.util.ContainersSwitch;
import org.emftext.language.java.imports.Import;
import org.emftext.language.java.imports.util.ImportsSwitch;
import org.emftext.language.java.members.Constructor;
import org.emftext.language.java.members.Field;
import org.emftext.language.java.members.Method;
import org.emftext.language.java.members.util.MembersSwitch;
import org.emftext.language.java.statements.Statement;
import org.emftext.language.java.statements.util.StatementsSwitch;
import org.emftext.language.java.types.TypeReference;
import org.emftext.language.java.types.util.TypesSwitch;
import org.splevo.jamopp.diffing.jamoppdiff.ClassChange;
import org.splevo.jamopp.diffing.jamoppdiff.CompilationUnitChange;
import org.splevo.jamopp.diffing.jamoppdiff.ConstructorChange;
import org.splevo.jamopp.diffing.jamoppdiff.EnumChange;
import org.splevo.jamopp.diffing.jamoppdiff.ExtendsChange;
import org.splevo.jamopp.diffing.jamoppdiff.FieldChange;
import org.splevo.jamopp.diffing.jamoppdiff.ImplementsChange;
import org.splevo.jamopp.diffing.jamoppdiff.ImportChange;
import org.splevo.jamopp.diffing.jamoppdiff.InterfaceChange;
import org.splevo.jamopp.diffing.jamoppdiff.JaMoPPDiffFactory;
import org.splevo.jamopp.diffing.jamoppdiff.MethodChange;
import org.splevo.jamopp.diffing.jamoppdiff.PackageChange;
import org.splevo.jamopp.diffing.jamoppdiff.StatementChange;

public class JaMoPPChangeFactory
extends ComposedSwitch<Diff> {
    public JaMoPPChangeFactory() {
        this.addSwitch((Switch)new ImportChangeFactory());
        this.addSwitch((Switch)new ClassifierChangeFactory());
        this.addSwitch((Switch)new MembersChangeFactory());
        this.addSwitch((Switch)new StatementsChangeFactory());
        this.addSwitch((Switch)new ContainersChangeFactory());
        this.addSwitch((Switch)new TypesChangeFactory());
    }

    public Diff defaultCase(EObject object) {
        return null;
    }

    private class ClassifierChangeFactory
    extends ClassifiersSwitch<Diff> {
        private ClassifierChangeFactory() {
        }

        public Diff caseClass(Class classDeclaration) {
            ClassChange classChange = JaMoPPDiffFactory.eINSTANCE.createClassChange();
            classChange.setChangedClass(classDeclaration);
            return classChange;
        }

        public Diff caseEnumeration(Enumeration object) {
            EnumChange enumChange = JaMoPPDiffFactory.eINSTANCE.createEnumChange();
            enumChange.setChangedEnum(object);
            return enumChange;
        }

        public Diff caseInterface(Interface object) {
            InterfaceChange interfaceChange = JaMoPPDiffFactory.eINSTANCE.createInterfaceChange();
            interfaceChange.setChangedInterface(object);
            return interfaceChange;
        }
    }

    private class ContainersChangeFactory
    extends ContainersSwitch<Diff> {
        private ContainersChangeFactory() {
        }

        public Diff casePackage(Package pckg) {
            PackageChange packageChange = JaMoPPDiffFactory.eINSTANCE.createPackageChange();
            packageChange.setChangedPackage(pckg);
            return packageChange;
        }

        public Diff caseCompilationUnit(CompilationUnit unit) {
            CompilationUnitChange unitChange = JaMoPPDiffFactory.eINSTANCE.createCompilationUnitChange();
            unitChange.setChangedCompilationUnit(unit);
            return unitChange;
        }
    }

    private class ImportChangeFactory
    extends ImportsSwitch<Diff> {
        private ImportChangeFactory() {
        }

        public Diff caseImport(Import object) {
            ImportChange importChange = JaMoPPDiffFactory.eINSTANCE.createImportChange();
            importChange.setChangedImport(object);
            return importChange;
        }
    }

    private class MembersChangeFactory
    extends MembersSwitch<Diff> {
        private MembersChangeFactory() {
        }

        public Diff caseField(Field field) {
            FieldChange fieldInsert = JaMoPPDiffFactory.eINSTANCE.createFieldChange();
            fieldInsert.setChangedField(field);
            return fieldInsert;
        }

        public Diff caseMethod(Method method) {
            MethodChange methodChange = JaMoPPDiffFactory.eINSTANCE.createMethodChange();
            methodChange.setChangedMethod(method);
            return methodChange;
        }

        public Diff caseConstructor(Constructor constructor) {
            ConstructorChange change = JaMoPPDiffFactory.eINSTANCE.createConstructorChange();
            change.setChangedConstructor(constructor);
            return change;
        }
    }

    private class StatementsChangeFactory
    extends StatementsSwitch<Diff> {
        private StatementsChangeFactory() {
        }

        public Diff caseStatement(Statement statement) {
            StatementChange statementChange = JaMoPPDiffFactory.eINSTANCE.createStatementChange();
            statementChange.setChangedStatement(statement);
            return statementChange;
        }
    }

    private class TypesChangeFactory
    extends TypesSwitch<Diff> {
        private TypesChangeFactory() {
        }

        public Diff caseTypeReference(TypeReference object) {
            Diff diff = null;
            EObject container = object.eContainer();
            if (container instanceof Class) {
                diff = this.handleReferenceInClass(object, (Class)container);
            } else if (container instanceof Interface) {
                diff = this.handleDifferenceInInterface(object, (Interface)container);
            }
            return diff;
        }

        private Diff handleDifferenceInInterface(TypeReference object, Interface interf) {
            if (interf.getExtends().contains((Object)object)) {
                ExtendsChange change = JaMoPPDiffFactory.eINSTANCE.createExtendsChange();
                change.setChangedReference(object);
                return change;
            }
            return null;
        }

        private Diff handleReferenceInClass(TypeReference object, Class clazz) {
            if (clazz.getExtends() == object) {
                ExtendsChange change = JaMoPPDiffFactory.eINSTANCE.createExtendsChange();
                change.setChangedReference(object);
                return change;
            }
            if (clazz.getImplements() != null && clazz.getImplements().contains((Object)object)) {
                ImplementsChange change = JaMoPPDiffFactory.eINSTANCE.createImplementsChange();
                change.setChangedReference(object);
                return change;
            }
            return null;
        }
    }
}

