/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing.postprocessor;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.ecore.EObject;
import org.emftext.language.java.classifiers.Class;
import org.emftext.language.java.classifiers.Classifier;
import org.emftext.language.java.containers.CompilationUnit;
import org.emftext.language.java.members.Constructor;
import org.emftext.language.java.parameters.Parameter;
import org.emftext.language.java.types.TypeReference;
import org.splevo.jamopp.diffing.jamoppdiff.ClassChange;
import org.splevo.jamopp.diffing.jamoppdiff.ConstructorChange;
import org.splevo.jamopp.diffing.jamoppdiff.ExtendsChange;
import org.splevo.jamopp.diffing.jamoppdiff.FieldChange;
import org.splevo.jamopp.diffing.jamoppdiff.ImportChange;
import org.splevo.jamopp.diffing.jamoppdiff.MethodChange;

public class DerivedCopyFilter {
    private static Logger logger = Logger.getLogger(DerivedCopyFilter.class);
    private boolean cleanImports = true;
    private boolean cleanFields = true;
    private boolean cleanMethods = true;

    public DerivedCopyFilter(boolean cleanImports, boolean cleanFields, boolean cleanMethods) {
        this.cleanImports = cleanImports;
        this.cleanFields = cleanFields;
        this.cleanMethods = cleanMethods;
    }

    public void cleanUpDerivedCopies(Comparison comparison) {
        LinkedHashSet falsePositivesToRemove = Sets.newLinkedHashSet();
        int counterClasses = 0;
        int counterImports = 0;
        int counterMethods = 0;
        int counterFields = 0;
        int counterTotalImports = 0;
        int counterTotalMethods = 0;
        int counterTotalFields = 0;
        LinkedHashSet alreadyProcessedOrigin = Sets.newLinkedHashSet();
        for (Diff diff : comparison.getDifferences()) {
            Match derivedCopyClassMatch = null;
            if (diff instanceof ClassChange) {
                if (this.checkDerivedCopyPattern(comparison, (ClassChange)diff)) {
                    derivedCopyClassMatch = diff.getMatch();
                }
            } else if (diff instanceof ExtendsChange && this.checkDerivedCopyPattern(comparison, (ExtendsChange)diff)) {
                derivedCopyClassMatch = diff.getMatch();
            }
            if (derivedCopyClassMatch == null) continue;
            falsePositivesToRemove.add(diff);
            Class originClass = (Class)diff.getMatch().getRight();
            if (alreadyProcessedOrigin.contains(originClass)) continue;
            alreadyProcessedOrigin.add(originClass);
            ++counterClasses;
            if (this.cleanImports) {
                List<ImportChange> importsToIgnore = this.identifyParentImportDeletes(diff);
                falsePositivesToRemove.addAll(importsToIgnore);
                counterImports += importsToIgnore.size();
            }
            if (this.cleanFields) {
                List<Diff> fieldsToIgnore = this.identifyParentFieldDeletes(derivedCopyClassMatch);
                falsePositivesToRemove.addAll(fieldsToIgnore);
                counterFields += fieldsToIgnore.size();
            }
            if (this.cleanMethods) {
                List<Diff> methodsToIgnore = this.identifyParentMethodDeletes(derivedCopyClassMatch);
                falsePositivesToRemove.addAll(methodsToIgnore);
                counterMethods += methodsToIgnore.size();
            }
            Class originalClass = (Class)derivedCopyClassMatch.getRight();
            counterTotalImports += this.countTotalImports(diff);
            counterTotalFields += this.countTotalFields(originalClass);
            counterTotalMethods += this.countTotalMethods(originalClass);
        }
        logger.debug((Object)String.format("Derived Copy Cleanup: Classes: %s, Imports: %s/%s, Fields: %s/%s, Methods: %s/%s", counterClasses, counterImports, counterTotalImports, counterFields, counterTotalFields, counterMethods, counterTotalMethods));
        for (Diff diff : falsePositivesToRemove) {
            diff.getMatch().getDifferences().remove((Object)diff);
        }
    }

    private int countTotalMethods(Class originalClass) {
        int methodCount = originalClass.getMethods().size();
        int constructorCount = originalClass.getConstructors().size();
        return methodCount + constructorCount;
    }

    private int countTotalFields(Class originalClass) {
        return originalClass.getFields().size();
    }

    private int countTotalImports(Diff change) {
        Match cuMatch = this.findCompilationUnitParentMatch(change);
        if (cuMatch.getRight() != null) {
            CompilationUnit cu = (CompilationUnit)cuMatch.getRight();
            return cu.getImports().size();
        }
        return 0;
    }

    private List<Diff> identifyParentMethodDeletes(Match classMatch) {
        Class copiedClass = (Class)classMatch.getLeft();
        LinkedList changesToIgnore = Lists.newLinkedList();
        for (Diff diff : classMatch.getDifferences()) {
            Constructor origConstructor;
            if (diff.getKind() != DifferenceKind.DELETE) continue;
            if (diff instanceof MethodChange) {
                changesToIgnore.add(diff);
            }
            if (!(diff instanceof ConstructorChange) || !this.hasEquivalentConstructor(copiedClass, origConstructor = ((ConstructorChange)diff).getChangedConstructor())) continue;
            changesToIgnore.add(diff);
        }
        return changesToIgnore;
    }

    private boolean hasEquivalentConstructor(Class copiedClass, Constructor origConstructor) {
        EList origParameters = origConstructor.getParameters();
        EList copyConstructors = copiedClass.getConstructors();
        if (origParameters.size() == 0 && copyConstructors.size() == 0) {
            return true;
        }
        for (Constructor copiedConstructor : copyConstructors) {
            EList copiedParameters = copiedConstructor.getParameters();
            if (copiedParameters.size() != origParameters.size()) continue;
            int i = 0;
            while (i < origParameters.size()) {
                Parameter copiedParam = (Parameter)copiedParameters.get(i);
                Parameter origParam = (Parameter)origParameters.get(i);
                TypeReference copiedTypeRef = copiedParam.getTypeReference();
                TypeReference origTypeRef = origParam.getTypeReference();
                if (copiedTypeRef.getPureClassifierReference() != null && origTypeRef.getPureClassifierReference() != null) {
                    Classifier copiedType = copiedTypeRef.getPureClassifierReference().getTarget();
                    Classifier origType = origTypeRef.getPureClassifierReference().getTarget();
                    if (!copiedType.getName().equals(origType.getName())) {
                        // empty if block
                    }
                } else if (origTypeRef.getTarget().eClass() != copiedTypeRef.getTarget().eClass()) {
                    // empty if block
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private List<Diff> identifyParentFieldDeletes(Match classMatch) {
        LinkedList changesToIgnore = Lists.newLinkedList();
        for (Diff diff : classMatch.getDifferences()) {
            if (diff.getKind() != DifferenceKind.DELETE || !(diff instanceof FieldChange)) continue;
            changesToIgnore.add(diff);
        }
        return changesToIgnore;
    }

    private List<ImportChange> identifyParentImportDeletes(Diff change) {
        Match cuMatch = this.findCompilationUnitParentMatch(change);
        if (cuMatch != null) {
            return this.getImportDeleteDiffs(cuMatch);
        }
        return Lists.newArrayList();
    }

    private List<ImportChange> getImportDeleteDiffs(Match cuMatch) {
        CompilationUnit originalCU = (CompilationUnit)cuMatch.getRight();
        Match primaryMatch = cuMatch.getComparison().getMatch((EObject)originalCU);
        ArrayList ignoreImports = Lists.newArrayList();
        for (Diff diff : primaryMatch.getDifferences()) {
            if (!(diff instanceof ImportChange) || diff.getKind() != DifferenceKind.DELETE) continue;
            ignoreImports.add((ImportChange)diff);
        }
        return ignoreImports;
    }

    private Match findCompilationUnitParentMatch(Diff change) {
        Match cuMatch = change.getMatch();
        while (cuMatch != null && !(cuMatch.getRight() instanceof CompilationUnit)) {
            cuMatch = this.getParentMatch(cuMatch);
        }
        return cuMatch;
    }

    private Match getParentMatch(Match match) {
        if (match != null && match.eContainer() instanceof Match) {
            return (Match)match.eContainer();
        }
        return null;
    }

    private boolean checkDerivedCopyPattern(Comparison comparison, ClassChange change) {
        if (!(change.getMatch().getRight() instanceof Class)) {
            return false;
        }
        Class originalClass = (Class)change.getMatch().getRight();
        Class changedClass = change.getChangedClass();
        TypeReference classExtends = changedClass.getExtends();
        if (classExtends == null) {
            return false;
        }
        Class superClass = (Class)classExtends.getPureClassifierReference().getTarget();
        if (!superClass.getQualifiedName().equals(originalClass.getQualifiedName())) {
            return false;
        }
        logger.debug((Object)("Derived Copy Detected: " + originalClass.getQualifiedName()));
        return true;
    }

    private boolean checkDerivedCopyPattern(Comparison comparison, ExtendsChange change) {
        if (!(change.getMatch().getRight() instanceof Class)) {
            return false;
        }
        Class originalClass = (Class)change.getMatch().getRight();
        TypeReference classExtends = change.getChangedReference();
        if (classExtends == null) {
            return false;
        }
        Class superClass = (Class)classExtends.getPureClassifierReference().getTarget();
        if (!superClass.getQualifiedName().equals(originalClass.getQualifiedName())) {
            return false;
        }
        logger.debug((Object)("Derived Copy Detected: " + originalClass.getQualifiedName()));
        return true;
    }
}

