/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing.postprocessor;

import com.google.common.collect.HashBasedTable;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.emftext.language.java.commons.Commentable;
import org.emftext.language.java.members.Constructor;
import org.emftext.language.java.members.Method;
import org.emftext.language.java.resource.java.IJavaTextResource;
import org.emftext.language.java.resource.java.mopp.JavaPrinter2;
import org.emftext.language.java.resource.java.mopp.JavaResource;
import org.emftext.language.java.statements.Statement;
import org.splevo.jamopp.diffing.jamoppdiff.CompilationUnitChange;
import org.splevo.jamopp.diffing.jamoppdiff.JaMoPPDiff;
import org.splevo.jamopp.diffing.jamoppdiff.StatementChange;

public class DifferenceStatisticLogger {
    private static Logger logger = Logger.getLogger(DifferenceStatisticLogger.class);

    public static void log(Comparison comparison, String logDir) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-hhmmss");
        if (!logDir.endsWith(File.separator)) {
            logDir = String.valueOf(logDir) + File.separator;
        }
        String runLogDir = String.valueOf(logDir) + dateFormat.format(new Date());
        DifferenceStatisticLogger.logDiffingStatistics(comparison, String.valueOf(runLogDir) + File.separator + "log-diffings-statistics.csv");
        DifferenceStatisticLogger.logDiffings(comparison, String.valueOf(runLogDir) + File.separator + "log-diffings.csv");
        DifferenceStatisticLogger.logResourceMatchings(comparison, String.valueOf(runLogDir) + File.separator + "log-resource-matches.csv");
    }

    private static void logDiffings(Comparison comparison, String filePath) {
        block19: {
            BufferedWriter writer = null;
            try {
                try {
                    File logFile = new File(filePath);
                    FileUtils.forceMkdir((File)logFile.getParentFile());
                    writer = new BufferedWriter(new FileWriter(logFile));
                    writer.write("ChangeKind , ChangeType , Containing Resource, Changed Element, Container Element \n");
                    for (Diff diff : comparison.getDifferences()) {
                        JaMoPPDiff change;
                        String containingResource = DifferenceStatisticLogger.getContainingResource(diff);
                        String changeKind = diff.getKind().getLiteral();
                        if (diff instanceof CompilationUnitChange) {
                            change = (CompilationUnitChange)diff;
                            writer.write(String.valueOf(changeKind) + ",CompilationUnitChange," + containingResource + "," + change.getChangedCompilationUnit().getName() + ",\n");
                            continue;
                        }
                        if (diff instanceof StatementChange) {
                            change = (StatementChange)diff;
                            Statement statement = change.getChangedStatement();
                            Method containingMethod = DifferenceStatisticLogger.getContainingMethod(statement);
                            String containingElement = null;
                            if (containingMethod != null) {
                                containingElement = String.valueOf(containingMethod.getName()) + "()";
                            } else if (statement.eContainer() instanceof Constructor) {
                                Constructor constructor = (Constructor)statement.eContainer();
                                containingElement = String.valueOf(constructor.getName()) + "()";
                            } else {
                                containingElement = "" + statement.eContainer();
                            }
                            writer.write(String.valueOf(changeKind) + ",StatementChange," + containingResource + "," + statement + "," + containingElement + "\n");
                            continue;
                        }
                        writer.write(String.valueOf(changeKind) + "," + diff.getClass().getSimpleName() + "," + containingResource + "\n");
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to write to statistic logger.", (Throwable)e);
                    if (writer == null) break block19;
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        logger.error((Object)"Failed to close statistic log writer.", (Throwable)e2);
                    }
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)"Failed to close statistic log writer.", (Throwable)e);
                    }
                }
            }
        }
    }

    private static String getContainingResource(Diff diff) {
        EObject orig = null;
        orig = diff.getMatch().getRight() != null ? diff.getMatch().getRight() : diff.getMatch().getLeft();
        String containingResource = null;
        containingResource = orig != null ? DifferenceStatisticLogger.getRelativeSourcePath(orig.eResource()) : "unknown";
        return containingResource;
    }

    private static String getStringRepresentation(Commentable element) {
        String printString = "";
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JavaPrinter2 printer = new JavaPrinter2((OutputStream)stream, (IJavaTextResource)new JavaResource());
        try {
            printer.print((EObject)element);
        }
        catch (IOException e) {
            System.err.println("Failed to print element");
        }
        printString = stream.toString();
        return printString;
    }

    private static Method getContainingMethod(Statement statement) {
        EObject container = statement.eContainer();
        Method containingMethod = null;
        while (container != null) {
            if (container instanceof Method) {
                containingMethod = (Method)container;
                break;
            }
            container = container.eContainer();
        }
        return containingMethod;
    }

    private static void logDiffingStatistics(Comparison comparison, String logFilePath) {
        block16: {
            HashBasedTable statistics = HashBasedTable.create();
            for (Diff diff : comparison.getDifferences()) {
                Integer current = (Integer)statistics.get(diff.getClass(), (Object)diff.getKind());
                if (current == null) {
                    current = 0;
                }
                current = current + 1;
                statistics.put(diff.getClass(), (Object)diff.getKind(), (Object)current);
            }
            BufferedWriter writer = null;
            try {
                try {
                    File logFile = new File(logFilePath);
                    FileUtils.forceMkdir((File)logFile.getParentFile());
                    writer = new BufferedWriter(new FileWriter(logFile));
                    writer.write("Type , Kind , Count \n");
                    for (Class rowKey : statistics.rowKeySet()) {
                        Map row = statistics.row((Object)rowKey);
                        for (DifferenceKind kind : row.keySet()) {
                            writer.write(String.valueOf(rowKey.getSimpleName()) + "," + kind.getLiteral() + "," + row.get(kind) + "\n");
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (writer == null) break block16;
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static void logResourceMatchings(Comparison comparison, String logFilePath) {
        block13: {
            BufferedWriter writer = null;
            try {
                try {
                    File logFile = new File(logFilePath);
                    FileUtils.forceMkdir((File)logFile.getParentFile());
                    writer = new BufferedWriter(new FileWriter(logFile));
                    for (MatchResource matchResource : comparison.getMatchedResources()) {
                        String left = DifferenceStatisticLogger.getRelativeSourcePath(matchResource.getLeft());
                        String right = DifferenceStatisticLogger.getRelativeSourcePath(matchResource.getRight());
                        if ("pathmap:/javaclass/java.lang.Object.java".equals(left)) continue;
                        writer.write(String.valueOf(left) + "," + right + "\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (writer == null) break block13;
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static String getRelativeSourcePath(Resource resource) {
        if (resource == null || resource.getURI() == null) {
            return "";
        }
        String absolutePath = resource.getURI().toString();
        if (absolutePath.indexOf("src") > -1) {
            absolutePath = absolutePath.substring(absolutePath.indexOf("src"));
        }
        return absolutePath;
    }
}

