/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diff.DefaultDiffEngine;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.diff.IDiffProcessor;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryRegistryImpl;
import org.eclipse.emf.compare.match.resource.IResourceMatcher;
import org.eclipse.emf.compare.postprocessor.BasicPostProcessorDescriptorImpl;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.postprocessor.PostProcessorDescriptorRegistryImpl;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EqualityHelper;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.emftext.commons.layout.LayoutPackage;
import org.emftext.language.java.JavaPackage;
import org.emftext.language.java.commons.Commentable;
import org.splevo.commons.emf.SPLevoResourceSet;
import org.splevo.diffing.Differ;
import org.splevo.diffing.DiffingException;
import org.splevo.diffing.DiffingNotSupportedException;
import org.splevo.diffing.match.HierarchicalMatchEngine;
import org.splevo.diffing.match.HierarchicalMatchEngineFactory;
import org.splevo.diffing.match.HierarchicalStrategyResourceMatcher;
import org.splevo.diffing.util.NormalizationUtil;
import org.splevo.extraction.SoftwareModelExtractionException;
import org.splevo.jamopp.diffing.diff.JaMoPPDiffBuilder;
import org.splevo.jamopp.diffing.diff.JaMoPPFeatureFilter;
import org.splevo.jamopp.diffing.match.JaMoPPEqualityHelper;
import org.splevo.jamopp.diffing.match.JaMoPPEqualityStrategy;
import org.splevo.jamopp.diffing.match.JaMoPPIgnoreStrategy;
import org.splevo.jamopp.diffing.postprocessor.JaMoPPPostProcessor;
import org.splevo.jamopp.diffing.scope.JavaModelMatchScope;
import org.splevo.jamopp.diffing.scope.PackageIgnoreChecker;
import org.splevo.jamopp.diffing.similarity.SimilarityChecker;
import org.splevo.jamopp.extraction.JaMoPPSoftwareModelExtractor;

public class JaMoPPDiffer
implements Differ {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String OPTION_JAMOPP_IGNORE_FILES = "JaMoPP.Files.to.ignore";
    public static final String OPTION_JAVA_IGNORE_PACKAGES = "JaMoPP.Java.Packages.to.ignore";
    public static final String OPTION_JAVA_PACKAGE_NORMALIZATION = "JaMoPP.Java.Package.Normalization.Pattern";
    public static final String OPTION_JAVA_CLASSIFIER_NORMALIZATION = "JaMoPP.Java.Classifier.Normalization.Pattern";
    private static final String LABEL = "JaMoPP Java Differ";
    private static final String ID = "org.splevo.jamopp.differ";
    private static Logger logger = Logger.getLogger(JaMoPPDiffer.class);
    private final JaMoPPSoftwareModelExtractor extractor;

    public JaMoPPDiffer() {
        this(new JaMoPPSoftwareModelExtractor());
    }

    public JaMoPPDiffer(JaMoPPSoftwareModelExtractor extractor) {
        this.extractor = extractor;
    }

    public Comparison doDiff(java.net.URI leadingModelDirectory, java.net.URI integrationModelDirectory, Map<String, String> diffingOptions) throws DiffingException, DiffingNotSupportedException {
        List<String> ignoreFiles = this.loadIgnoreFileConfiguration(diffingOptions);
        logger.info((Object)"Load source models");
        ResourceSet resourceSetLeading = this.loadResourceSetRecursively(leadingModelDirectory, ignoreFiles);
        ResourceSet resourceSetIntegration = this.loadResourceSetRecursively(integrationModelDirectory, ignoreFiles);
        return this.doDiff(resourceSetLeading, resourceSetIntegration, diffingOptions);
    }

    private List<String> loadIgnoreFileConfiguration(Map<String, String> diffingOptions) {
        List ignoreFiles;
        if (diffingOptions.containsKey(OPTION_JAMOPP_IGNORE_FILES)) {
            String diffingRuleRaw = diffingOptions.get(OPTION_JAMOPP_IGNORE_FILES);
            String[] parts = diffingRuleRaw.split(LINE_SEPARATOR);
            ignoreFiles = Lists.newArrayList();
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String rule = stringArray[n2];
                ignoreFiles.add(rule);
                ++n2;
            }
        } else {
            ignoreFiles = Lists.asList((Object)"package-info.java", (Object[])new String[0]);
        }
        return ignoreFiles;
    }

    public Comparison doDiff(ResourceSet resourceSetLeading, ResourceSet resourceSetIntegration, Map<String, String> diffingOptions) throws DiffingException, DiffingNotSupportedException {
        List<String> ignorePackages = this.buildIgnorePackageList(diffingOptions);
        PackageIgnoreChecker packageIgnoreChecker = new PackageIgnoreChecker(ignorePackages);
        EMFCompare comparator = this.initCompare(packageIgnoreChecker, diffingOptions);
        JavaModelMatchScope scope = new JavaModelMatchScope((Notifier)resourceSetIntegration, (Notifier)resourceSetLeading, packageIgnoreChecker);
        Comparison comparisonModel = comparator.compare((IComparisonScope)scope);
        return comparisonModel;
    }

    public Comparison doDiff(Commentable rightElement, Commentable leftElement, Map<String, String> diffingOptions) {
        ArrayList ignorePackages = Lists.newArrayList();
        PackageIgnoreChecker packageIgnoreChecker = new PackageIgnoreChecker(ignorePackages);
        EMFCompare comparator = this.initCompare(packageIgnoreChecker, diffingOptions);
        JavaModelMatchScope scope = new JavaModelMatchScope((Notifier)leftElement, (Notifier)rightElement, packageIgnoreChecker);
        Comparison comparisonModel = comparator.compare((IComparisonScope)scope);
        return comparisonModel;
    }

    private List<String> buildIgnorePackageList(Map<String, String> diffingOptions) {
        String diffingRuleRaw = diffingOptions.get(OPTION_JAVA_IGNORE_PACKAGES);
        ArrayList ignorePackages = Lists.newArrayList();
        if (diffingRuleRaw != null) {
            String[] parts;
            String[] stringArray = parts = diffingRuleRaw.split(LINE_SEPARATOR);
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String rule = stringArray[n2];
                ignorePackages.add(rule);
                ++n2;
            }
        }
        return ignorePackages;
    }

    private EMFCompare initCompare(PackageIgnoreChecker packageIgnoreChecker, Map<String, String> diffingOptions) {
        IMatchEngine.Factory.Registry matchEngineRegistry = this.initMatchEngine(packageIgnoreChecker, diffingOptions);
        IPostProcessor.Descriptor.Registry<String> postProcessorRegistry = this.initPostProcessors(packageIgnoreChecker, diffingOptions);
        IDiffEngine diffEngine = this.initDiffEngine(packageIgnoreChecker);
        EMFCompare comparator = this.initComparator(matchEngineRegistry, postProcessorRegistry, diffEngine);
        return comparator;
    }

    private LoadingCache<EObject, URI> initEqualityCache() {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumSize(1024L);
        LoadingCache cache = EqualityHelper.createDefaultCache((CacheBuilder)cacheBuilder);
        return cache;
    }

    private IPostProcessor.Descriptor.Registry<String> initPostProcessors(PackageIgnoreChecker packageIgnoreChecker, Map<String, String> diffingOptions) {
        JaMoPPPostProcessor customPostProcessor = new JaMoPPPostProcessor(diffingOptions);
        Pattern any = Pattern.compile(".*");
        BasicPostProcessorDescriptorImpl descriptor = new BasicPostProcessorDescriptorImpl((IPostProcessor)customPostProcessor, any, any);
        PostProcessorDescriptorRegistryImpl postProcessorRegistry = new PostProcessorDescriptorRegistryImpl();
        postProcessorRegistry.put((Object)JaMoPPPostProcessor.class.getName(), (IPostProcessor.Descriptor)descriptor);
        return postProcessorRegistry;
    }

    private EMFCompare initComparator(IMatchEngine.Factory.Registry matchEngineRegistry, IPostProcessor.Descriptor.Registry<?> postProcessorRegistry, IDiffEngine diffEngine) {
        EMFCompare.Builder builder = EMFCompare.builder();
        builder.setDiffEngine(diffEngine);
        builder.setMatchEngineFactoryRegistry(matchEngineRegistry);
        builder.setPostProcessorRegistry(postProcessorRegistry);
        EMFCompare comparator = builder.build();
        return comparator;
    }

    private IDiffEngine initDiffEngine(final PackageIgnoreChecker packageIgnoreChecker) {
        final JaMoPPDiffBuilder diffProcessor = new JaMoPPDiffBuilder(packageIgnoreChecker);
        DefaultDiffEngine diffEngine = new DefaultDiffEngine((IDiffProcessor)diffProcessor){

            protected FeatureFilter createFeatureFilter() {
                return new JaMoPPFeatureFilter(packageIgnoreChecker);
            }

            public void diff(Comparison comparison, Monitor monitor) {
                for (Match rootMatch : comparison.getMatches()) {
                    if (this.isSingleSideRootMatch(rootMatch)) {
                        diffProcessor.createRootDiff(rootMatch);
                        continue;
                    }
                    this.checkForDifferences(rootMatch, monitor);
                }
            }

            private boolean isSingleSideRootMatch(Match rootMatch) {
                return rootMatch.getSubmatches().size() == 0 && (rootMatch.getLeft() == null || rootMatch.getRight() == null);
            }
        };
        return diffEngine;
    }

    private IMatchEngine.Factory.Registry initMatchEngine(PackageIgnoreChecker packageIgnoreChecker, Map<String, String> diffingOptions) {
        SimilarityChecker similarityChecker = this.initSimilarityChecker(diffingOptions);
        IEqualityHelper equalityHelper = this.initEqualityHelper(similarityChecker);
        JaMoPPEqualityStrategy equalityStrategy = new JaMoPPEqualityStrategy(similarityChecker);
        JaMoPPIgnoreStrategy ignoreStrategy = new JaMoPPIgnoreStrategy(packageIgnoreChecker);
        HierarchicalStrategyResourceMatcher resourceMatcher = this.initResourceMatcher(diffingOptions);
        HierarchicalMatchEngineFactory matchEngineFactory = new HierarchicalMatchEngineFactory(equalityHelper, (HierarchicalMatchEngine.EqualityStrategy)equalityStrategy, (HierarchicalMatchEngine.IgnoreStrategy)ignoreStrategy, (IResourceMatcher)resourceMatcher);
        matchEngineFactory.setRanking(20);
        MatchEngineFactoryRegistryImpl matchEngineRegistry = new MatchEngineFactoryRegistryImpl();
        matchEngineRegistry.add((IMatchEngine.Factory)matchEngineFactory);
        return matchEngineRegistry;
    }

    private SimilarityChecker initSimilarityChecker(Map<String, String> diffingOptions) {
        String configString = diffingOptions.get(OPTION_JAVA_CLASSIFIER_NORMALIZATION);
        LinkedHashMap classifierNorms = NormalizationUtil.loadRemoveNormalizations((String)configString, null);
        LinkedHashMap compUnitNorms = NormalizationUtil.loadRemoveNormalizations((String)configString, (String)".java");
        String configStringPackage = diffingOptions.get(OPTION_JAVA_PACKAGE_NORMALIZATION);
        LinkedHashMap packageNorms = NormalizationUtil.loadReplaceNormalizations((String)configStringPackage);
        return new SimilarityChecker(classifierNorms, compUnitNorms, packageNorms);
    }

    private IEqualityHelper initEqualityHelper(SimilarityChecker similarityChecker) {
        LoadingCache<EObject, URI> cache = this.initEqualityCache();
        JaMoPPEqualityHelper equalityHelper = new JaMoPPEqualityHelper(cache, similarityChecker);
        return equalityHelper;
    }

    private HierarchicalStrategyResourceMatcher initResourceMatcher(Map<String, String> diffingOptions) {
        String packageNormConfig = diffingOptions.get(OPTION_JAVA_PACKAGE_NORMALIZATION);
        LinkedHashMap uriNormalizations = NormalizationUtil.loadReplaceNormalizations((String)packageNormConfig);
        String classNormConfig = diffingOptions.get(OPTION_JAVA_CLASSIFIER_NORMALIZATION);
        LinkedHashMap fileNormalizations = NormalizationUtil.loadRemoveNormalizations((String)classNormConfig, (String)".java");
        HierarchicalStrategyResourceMatcher resourceMatcher = new HierarchicalStrategyResourceMatcher(uriNormalizations, fileNormalizations);
        return resourceMatcher;
    }

    public String getId() {
        return ID;
    }

    public String getLabel() {
        return LABEL;
    }

    public void init() {
        JavaPackage.eINSTANCE.eClass();
        LayoutPackage.eINSTANCE.eClass();
    }

    private ResourceSet loadResourceSetRecursively(java.net.URI baseDirectory, List<String> ignoreFiles) {
        ArrayList<String> projectPaths = new ArrayList<String>();
        projectPaths.add(new File(baseDirectory).getAbsolutePath());
        try {
            return this.extractor.extractSoftwareModel(projectPaths, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (SoftwareModelExtractionException e) {
            logger.error((Object)"Failed to load resource set", (Throwable)e);
            return new SPLevoResourceSet();
        }
    }

    public Map<String, String> getAvailableConfigurations() {
        HashMap options = Maps.newHashMap();
        options.put(OPTION_JAVA_IGNORE_PACKAGES, "java.*\njavax.*");
        options.put(OPTION_JAMOPP_IGNORE_FILES, "package-info.java");
        options.put(OPTION_JAVA_CLASSIFIER_NORMALIZATION, "");
        options.put(OPTION_JAVA_PACKAGE_NORMALIZATION, "");
        options.put("JaMoPP.Differ.Derived.Copy.Cleanup", "");
        options.put("JaMoPP.Differ.Statistics.Log.Directory", "");
        return options;
    }

    public int getOrderId() {
        return 0;
    }

    public Set<String> getRequiredExtractorIds() {
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        ids.add("JaMoPPSoftwareModelExtractor");
        return ids;
    }
}

