/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing.postprocessor;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.ecore.EObject;
import org.emftext.language.java.classifiers.Class;
import org.emftext.language.java.commons.Commentable;
import org.emftext.language.java.expressions.Expression;
import org.emftext.language.java.statements.Statement;
import org.splevo.diffing.postprocessor.ComparisonModelCleanUp;
import org.splevo.jamopp.diffing.diff.JaMoPPChangeFactory;
import org.splevo.jamopp.diffing.jamoppdiff.StatementChange;
import org.splevo.jamopp.diffing.postprocessor.DerivedCopyFilter;
import org.splevo.jamopp.diffing.postprocessor.DifferenceStatisticLogger;
import org.splevo.jamopp.util.JaMoPPElementUtil;

public class JaMoPPPostProcessor
implements IPostProcessor {
    private Logger logger = Logger.getLogger(JaMoPPPostProcessor.class);
    private JaMoPPChangeFactory customChangeFactory = new JaMoPPChangeFactory();
    private Map<EObject, Diff> refinedDiffCache = new LinkedHashMap<EObject, Diff>();
    private Map<String, Object> options = Maps.newHashMap();
    public static final String OPTION_DIFF_STATISTICS_LOG_DIR = "JaMoPP.Differ.Statistics.Log.Directory";
    public static final String OPTION_DIFF_CLEANUP_DERIVED_COPIES = "JaMoPP.Differ.Derived.Copy.Cleanup";
    public static final String OPTION_DIFF_CLEANUP_DERIVED_COPIES_CLEAN_IMPORTS = "JaMoPP.Differ.Derived.Copy.Cleanup.Imports";
    public static final String OPTION_DIFF_CLEANUP_DERIVED_COPIES_CLEAN_FIELDS = "JaMoPP.Differ.Derived.Copy.Cleanup.Fields";
    public static final String OPTION_DIFF_CLEANUP_DERIVED_COPIES_CLEAN_METHODS = "JaMoPP.Differ.Derived.Copy.Cleanup.Methods";

    public JaMoPPPostProcessor() {
        this.options.put(OPTION_DIFF_STATISTICS_LOG_DIR, null);
        this.options.put(OPTION_DIFF_CLEANUP_DERIVED_COPIES, null);
        this.options.put(OPTION_DIFF_CLEANUP_DERIVED_COPIES_CLEAN_IMPORTS, "true");
        this.options.put(OPTION_DIFF_CLEANUP_DERIVED_COPIES_CLEAN_FIELDS, "true");
        this.options.put(OPTION_DIFF_CLEANUP_DERIVED_COPIES_CLEAN_METHODS, "true");
    }

    public JaMoPPPostProcessor(Map<String, String> options) {
        this();
        if (options != null) {
            for (String key : options.keySet()) {
                this.options.put(key, options.get(key));
            }
        }
    }

    public void postMatch(Comparison comparison, Monitor monitor) {
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
        this.refineTooDetailedDiffs(comparison);
        this.cleanNestedDifferences(comparison);
    }

    private void refineTooDetailedDiffs(Comparison comparison) {
        for (Diff diff : comparison.getDifferences()) {
            Diff refinedDiff = this.refineToDetailedDiff(diff);
            if (refinedDiff == null) continue;
            Match match = diff.getMatch();
            match.getDifferences().remove((Object)diff);
            this.logger.info((Object)("PostDiff: Refined to detailed Diff: " + diff));
        }
    }

    private void cleanNestedDifferences(Comparison comparison) {
        HashSet<Diff> diffsToRemove = new HashSet<Diff>();
        block0: for (Diff diff : comparison.getDifferences()) {
            Match parentMatch = this.getParentMatch(diff.getMatch());
            while (parentMatch != null) {
                if (parentMatch.getDifferences().size() > 0 && this.atLeastOneDiffIsStatement(parentMatch) && this.oneIsParent(parentMatch, diff) && this.noClassElement(parentMatch)) {
                    diffsToRemove.add(diff);
                    continue block0;
                }
                parentMatch = this.getParentMatch(parentMatch);
            }
        }
        for (Diff diff : diffsToRemove) {
            diff.getMatch().getDifferences().remove((Object)diff);
        }
    }

    private boolean oneIsParent(Match parentMatch, Diff diff) {
        if (!(diff instanceof StatementChange)) {
            return false;
        }
        Statement childStmt = ((StatementChange)diff).getChangedStatement();
        for (Diff parentDiff : parentMatch.getDifferences()) {
            if (!(parentDiff instanceof StatementChange)) continue;
            Statement parentStmt = ((StatementChange)parentDiff).getChangedStatement();
            if (JaMoPPElementUtil.isParentOf((Commentable)parentStmt, (Commentable)childStmt)) {
                return true;
            }
            if (!(parentMatch.getRight() == parentStmt ? JaMoPPElementUtil.isParentOf((Commentable)((Statement)parentMatch.getLeft()), (Commentable)childStmt) : parentMatch.getLeft() == parentStmt && JaMoPPElementUtil.isParentOf((Commentable)((Statement)parentMatch.getRight()), (Commentable)childStmt))) continue;
            return true;
        }
        return false;
    }

    private boolean atLeastOneDiffIsStatement(Match parentMatch) {
        return parentMatch.getLeft() instanceof Statement || parentMatch.getRight() instanceof Statement;
    }

    private boolean noClassElement(Match parentMatch) {
        EObject left = parentMatch.getLeft();
        EObject right = parentMatch.getRight();
        return !this.isClassElement(left) && !this.isClassElement(right);
    }

    private boolean isClassElement(EObject object) {
        return object instanceof Class;
    }

    private Diff refineToDetailedDiff(Diff diff) {
        if (diff instanceof ReferenceChange) {
            return this.refineToDetailedReferenceChange((ReferenceChange)diff);
        }
        if (diff instanceof AttributeChange) {
            return this.refineToDetailedAttributeChange((AttributeChange)diff);
        }
        return null;
    }

    private Diff refineToDetailedReferenceChange(ReferenceChange referenceChange) {
        EObject changedValue = referenceChange.getValue();
        if (changedValue instanceof Expression) {
            Match parentMatch = referenceChange.getMatch();
            Diff refinedDiff = null;
            while (refinedDiff == null && parentMatch != null) {
                EObject parentElement = null;
                parentElement = parentMatch.getRight() != null ? parentMatch.getRight() : parentMatch.getLeft();
                if (this.refinedDiffCache.containsKey(parentElement)) {
                    refinedDiff = this.refinedDiffCache.get(parentElement);
                    refinedDiff.getRefinedBy().add((Object)referenceChange);
                    return refinedDiff;
                }
                refinedDiff = (Diff)this.customChangeFactory.doSwitch(parentElement);
                if (refinedDiff != null) {
                    Match nextParentMatch = this.getParentMatch(parentMatch);
                    refinedDiff.setKind(DifferenceKind.CHANGE);
                    refinedDiff.setMatch(nextParentMatch);
                    refinedDiff.getRefinedBy().add((Object)referenceChange);
                    nextParentMatch.getDifferences().add((Object)refinedDiff);
                    this.refinedDiffCache.put(parentElement, refinedDiff);
                    return refinedDiff;
                }
                parentMatch = this.getParentMatch(parentMatch);
            }
        }
        return null;
    }

    private Diff refineToDetailedAttributeChange(AttributeChange attributeChange) {
        this.logger.warn((Object)("Unhandled AttributeChange (" + attributeChange + ")"));
        return null;
    }

    public void postRequirements(Comparison comparison, Monitor monitor) {
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    public void postComparison(Comparison comparison, Monitor monitor) {
        String logDirPath;
        Object logDir = this.options.get(OPTION_DIFF_STATISTICS_LOG_DIR);
        if (logDir != null && logDir instanceof String && !(logDirPath = (String)logDir).trim().isEmpty()) {
            DifferenceStatisticLogger.log(comparison, String.valueOf((String)logDir) + File.separator + "postcomparison");
        }
        if (this.isCleanUpDerivedCopiesActivated()) {
            String logDirPath2;
            boolean cleanImports = this.isOptionNotNull(OPTION_DIFF_CLEANUP_DERIVED_COPIES_CLEAN_IMPORTS);
            boolean cleanFields = this.isOptionNotNull(OPTION_DIFF_CLEANUP_DERIVED_COPIES_CLEAN_FIELDS);
            boolean cleanMethods = this.isOptionNotNull(OPTION_DIFF_CLEANUP_DERIVED_COPIES_CLEAN_METHODS);
            DerivedCopyFilter filter = new DerivedCopyFilter(cleanImports, cleanFields, cleanMethods);
            filter.cleanUpDerivedCopies(comparison);
            if (logDir != null && logDir instanceof String && !(logDirPath2 = (String)logDir).trim().isEmpty()) {
                DifferenceStatisticLogger.log(comparison, String.valueOf((String)logDir) + File.separator + "after-derived-copy");
            }
        }
        ComparisonModelCleanUp.cleanMatches((EList)comparison.getMatches());
    }

    private boolean isCleanUpDerivedCopiesActivated() {
        return this.isOptionNotNull(OPTION_DIFF_CLEANUP_DERIVED_COPIES);
    }

    private boolean isOptionNotNull(String optionKey) {
        String cleanUpDerivedCopiesString;
        boolean cleanUpDerivedImportsActive = false;
        Object cleanUpDerivedCopies = this.options.get(optionKey);
        if (cleanUpDerivedCopies != null && cleanUpDerivedCopies instanceof String && !(cleanUpDerivedCopiesString = (String)cleanUpDerivedCopies).trim().isEmpty()) {
            cleanUpDerivedImportsActive = true;
        }
        return cleanUpDerivedImportsActive;
    }

    private Match getParentMatch(Match match) {
        if (match != null && match.eContainer() instanceof Match) {
            return (Match)match.eContainer();
        }
        return null;
    }
}

