/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing.scope;

import com.google.common.base.Predicate;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.emftext.commons.layout.LayoutInformation;
import org.emftext.language.java.containers.CompilationUnit;
import org.emftext.language.java.containers.Package;
import org.splevo.jamopp.diffing.scope.PackageIgnoreChecker;

public class JavaModelMatchScope
extends DefaultComparisonScope {
    private PackageIgnoreChecker packageIgnoreChecker;
    private static final String PACKAGE_INFO_FILENAME = "package-info.java";

    public JavaModelMatchScope(Notifier left, Notifier right, PackageIgnoreChecker packageIgnoreChecker) {
        super(left, right, null);
        this.packageIgnoreChecker = packageIgnoreChecker;
        EObjectInScopePredicate predicate = new EObjectInScopePredicate();
        this.setEObjectContentFilter(predicate);
        this.setResourceContentFilter(predicate);
        this.setResourceSetContentFilter(new ResourceInScopePredicate());
    }

    private class EObjectInScopePredicate
    implements Predicate<EObject> {
        private EObjectInScopePredicate() {
        }

        public boolean apply(EObject input) {
            CompilationUnit compUnit;
            if (input instanceof LayoutInformation) {
                return false;
            }
            if (input instanceof CompilationUnit && JavaModelMatchScope.PACKAGE_INFO_FILENAME.equals((compUnit = (CompilationUnit)input).getName())) {
                return false;
            }
            Boolean isInIgnorePackage = JavaModelMatchScope.this.packageIgnoreChecker.isInIgnorePackage(input);
            return isInIgnorePackage != Boolean.TRUE;
        }
    }

    private class ResourceInScopePredicate
    implements Predicate<Resource> {
        private ResourceInScopePredicate() {
        }

        public boolean apply(Resource input) {
            if (input.getURI().toString().startsWith("pathmap:/javaclass/")) {
                return false;
            }
            for (EObject rootElement : input.getContents()) {
                if (rootElement instanceof CompilationUnit) {
                    return true;
                }
                if (!(rootElement instanceof Package)) continue;
                return true;
            }
            return false;
        }
    }
}

