/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing.similarity;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.splevo.jamopp.diffing.similarity.SimilaritySwitch;

public class SimilarityChecker {
    private Logger logger = Logger.getLogger(SimilarityChecker.class);
    private LinkedHashMap<Pattern, String> classifierNormalizations = null;
    private LinkedHashMap<Pattern, String> compilationUnitNormalizations = null;
    private LinkedHashMap<Pattern, String> packageNormalizations = null;

    public SimilarityChecker(LinkedHashMap<Pattern, String> classifierNormalizations, LinkedHashMap<Pattern, String> compilationUnitNormalizations, LinkedHashMap<Pattern, String> packageNormalizations) {
        this.classifierNormalizations = classifierNormalizations;
        this.compilationUnitNormalizations = compilationUnitNormalizations;
        this.packageNormalizations = packageNormalizations;
    }

    public SimilarityChecker() {
        this.classifierNormalizations = Maps.newLinkedHashMap();
        this.compilationUnitNormalizations = Maps.newLinkedHashMap();
        this.packageNormalizations = Maps.newLinkedHashMap();
    }

    public Boolean areSimilar(List<? extends EObject> elements1, List<? extends EObject> elements2) {
        if (elements1.size() != elements2.size()) {
            return Boolean.FALSE;
        }
        int i = 0;
        while (i < elements1.size()) {
            Boolean childSimilarity = this.isSimilar(elements1.get(i), elements2.get(i));
            if (childSimilarity == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            ++i;
        }
        return Boolean.TRUE;
    }

    public Boolean isSimilar(EObject element1, EObject element2) {
        return this.isSimilar(element1, element2, true);
    }

    public Boolean isSimilar(EObject element1, EObject element2, boolean checkStatementPosition) {
        if (element1 == element2) {
            return Boolean.TRUE;
        }
        if (this.onlyOneIsNull(element1, element2).booleanValue()) {
            return Boolean.FALSE;
        }
        if (element2.eIsProxy() && !element1.eIsProxy()) {
            element2 = EcoreUtil.resolve((EObject)element2, (EObject)element1);
        } else if (element1.eIsProxy() && !element2.eIsProxy()) {
            element1 = EcoreUtil.resolve((EObject)element1, (EObject)element2);
        }
        if (!element1.getClass().equals(element2.getClass())) {
            return Boolean.FALSE;
        }
        SimilaritySwitch similaritySwitch = new SimilaritySwitch(element2, checkStatementPosition, this.classifierNormalizations, this.compilationUnitNormalizations, this.packageNormalizations);
        Boolean similar = (Boolean)similaritySwitch.doSwitch(element1);
        return similar;
    }

    private Boolean onlyOneIsNull(EObject element1, EObject element2) {
        Boolean onlyOneIsNull = false;
        if (element1 != null && element2 == null) {
            onlyOneIsNull = Boolean.TRUE;
        } else if (element1 == null && element2 != null) {
            onlyOneIsNull = Boolean.TRUE;
        }
        return onlyOneIsNull;
    }
}

