/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.extraction;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.emftext.commons.layout.LayoutInformation;
import org.emftext.language.java.classifiers.ConcreteClassifier;
import org.emftext.language.java.containers.CompilationUnit;
import org.emftext.language.java.modifiers.Public;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.extraction.SoftwareModelExtractionException;
import org.splevo.jamopp.extraction.JaMoPPSoftwareModelExtractor;

public class JaMoPPSoftwareModelExtractorTest {
    private Logger logger = Logger.getLogger(JaMoPPSoftwareModelExtractorTest.class);

    @BeforeClass
    public static void setUp() {
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
    }

    @Test
    public void testExtractSoftwareModel() throws SoftwareModelExtractionException {
        String testProjectPath = "testcode/project/calculator-jscience";
        JaMoPPSoftwareModelExtractor extractor = new JaMoPPSoftwareModelExtractor();
        ArrayList projectPaths = Lists.newArrayList((Object[])new String[]{new File(testProjectPath).getAbsolutePath()});
        ResourceSet extractionResult = extractor.extractSoftwareModel((List)projectPaths, (IProgressMonitor)new NullProgressMonitor(), null);
        Assert.assertThat((Object)extractionResult, (Matcher)CoreMatchers.notNullValue());
        int projectResourceCount = 0;
        ArrayList<Resource> projectResources = new ArrayList<Resource>();
        for (Resource resource : extractionResult.getResources()) {
            String[] segments = resource.getURI().segments();
            if ("calculator".equals(segments[segments.length - 2])) {
                ++projectResourceCount;
                projectResources.add(resource);
            }
            for (EObject topLevelEObject : resource.getContents()) {
                if (topLevelEObject instanceof CompilationUnit) continue;
                this.logger.info((Object)("TopLevelEObject: " + topLevelEObject.getClass().getSimpleName()));
            }
        }
        int expectedTestClasses = 3;
        Assert.assertThat((Object)projectResourceCount, (Matcher)CoreMatchers.equalTo((Object)expectedTestClasses));
    }

    @Test
    public void testExtractLayoutInformation() throws SoftwareModelExtractionException {
        String testProjectPath = "testcode/layoutinformation";
        JaMoPPSoftwareModelExtractor extractor = new JaMoPPSoftwareModelExtractor();
        ArrayList projectPaths = Lists.newArrayList((Object[])new String[]{new File(testProjectPath).getAbsolutePath()});
        ResourceSet resourceSet = extractor.extractSoftwareModel((List)projectPaths, (IProgressMonitor)new NullProgressMonitor(), null, true);
        Assert.assertThat((Object)resourceSet, (Matcher)CoreMatchers.notNullValue());
        Resource resource = (Resource)resourceSet.getResources().get(0);
        CompilationUnit cu = (CompilationUnit)resource.getContents().get(0);
        ConcreteClassifier classA = (ConcreteClassifier)cu.getClassifiers().get(0);
        Public publicModifier = (Public)classA.getAnnotationsAndModifiers().get(0);
        String comment = ((LayoutInformation)publicModifier.getLayoutInformations().get(0)).getHiddenTokenText();
        Assert.assertThat((Object)comment, (Matcher)CoreMatchers.containsString((String)"Test Comment"));
    }

    @Test
    public void testGetId() {
        JaMoPPSoftwareModelExtractor extractor = new JaMoPPSoftwareModelExtractor();
        Assert.assertThat((Object)extractor.getId(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetLabel() {
        JaMoPPSoftwareModelExtractor extractor = new JaMoPPSoftwareModelExtractor();
        Assert.assertThat((Object)extractor.getLabel(), (Matcher)CoreMatchers.notNullValue());
    }
}

