/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.extraction;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.emftext.language.java.JavaClasspath;
import org.emftext.language.java.resource.JavaSourceOrClassFileResourceFactoryImpl;
import org.splevo.commons.emf.FileResourceHandling;
import org.splevo.commons.emf.SPLevoResourceSet;
import org.splevo.extraction.SoftwareModelExtractionException;
import org.splevo.extraction.SoftwareModelExtractor;
import org.splevo.jamopp.extraction.cache.ReferenceCache;
import org.splevo.jamopp.extraction.resource.JavaSourceOrClassFileResourceCachingFactoryImpl;

public class JaMoPPSoftwareModelExtractor
implements SoftwareModelExtractor {
    private static Logger logger = Logger.getLogger(JaMoPPSoftwareModelExtractor.class);
    public static final boolean EXTRACTOR_EXTRACT_LAYOUT_BY_DEFAULT = false;
    public static final String EXTRACTOR_ID = "JaMoPPSoftwareModelExtractor";
    private static final String EXTRACTOR_LABEL = "JaMoPP Software Model Extractor";

    public ResourceSet extractSoftwareModel(List<String> projectPaths, IProgressMonitor monitor) throws SoftwareModelExtractionException {
        return this.extractSoftwareModel(projectPaths, monitor, null);
    }

    public ResourceSet extractSoftwareModel(List<String> projectPaths, IProgressMonitor monitor, String sourceModelPath) throws SoftwareModelExtractionException {
        return this.extractSoftwareModel(projectPaths, monitor, sourceModelPath, false);
    }

    public ResourceSet extractSoftwareModel(List<String> projectPaths, IProgressMonitor monitor, String sourceModelPath, boolean extractLayoutInfo) throws SoftwareModelExtractionException {
        if (sourceModelPath != null) {
            logger.info((Object)("Use cache file: " + sourceModelPath));
        }
        List<String> jarFiles = this.getAllJarFiles(projectPaths);
        ResourceSet targetResourceSet = this.setUpResourceSet(sourceModelPath, jarFiles, extractLayoutInfo);
        ArrayList resources = Lists.newArrayList();
        for (String projectPath : projectPaths) {
            List<Resource> projectResources = this.loadProjectJavaFiles(targetResourceSet, projectPath);
            resources.addAll(projectResources);
        }
        logger.info((Object)String.format("%d Java and %d Jar Files added to resource set", resources.size(), jarFiles.size()));
        ReferenceCache cache = this.getReferenceCache(targetResourceSet);
        for (Resource resource : resources) {
            cache.resolve(resource);
        }
        this.triggerCacheSave(targetResourceSet);
        return targetResourceSet;
    }

    private List<Resource> loadProjectJavaFiles(ResourceSet targetResourceSet, String projectPath) throws SoftwareModelExtractionException {
        List<Resource> projectResources;
        try {
            File srcFolder = new File(projectPath);
            srcFolder.isDirectory();
            projectResources = this.loadAllJavaFilesInResourceSet(srcFolder, targetResourceSet);
        }
        catch (Exception e) {
            throw new SoftwareModelExtractionException("Failed to parse project resources. Project: " + projectPath, (Throwable)e);
        }
        return projectResources;
    }

    private List<String> getAllJarFiles(List<String> projectPaths) {
        ArrayList jarPaths = Lists.newArrayList();
        for (String projectPath : projectPaths) {
            File projectDirectory = new File(projectPath);
            Collection jarFiles = FileUtils.listFiles((File)projectDirectory, (String[])new String[]{"jar"}, (boolean)true);
            for (File jarPath : jarFiles) {
                if (!jarPath.exists()) continue;
                try {
                    jarPaths.add(jarPath.getCanonicalPath());
                }
                catch (IOException e) {
                    logger.warn((Object)("Unable to access jar file: " + jarPath));
                }
            }
        }
        return jarPaths;
    }

    private void triggerCacheSave(ResourceSet targetResourceSet) {
        ReferenceCache cache = this.getReferenceCache(targetResourceSet);
        logger.debug((Object)("References not resolved from Cache: " + cache.getNotResolvedFromCacheCounterReference()));
        cache.save();
    }

    private ReferenceCache getReferenceCache(ResourceSet resourceSet) {
        Map factoryMap = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        Object factoryObject = factoryMap.get("java");
        JavaSourceOrClassFileResourceCachingFactoryImpl factory = (JavaSourceOrClassFileResourceCachingFactoryImpl)factoryObject;
        ReferenceCache cache = factory.getReferenceCache();
        return cache;
    }

    private List<Resource> loadAllJavaFilesInResourceSet(File rootFolder, ResourceSet rs) throws IOException {
        ArrayList resources = Lists.newArrayList();
        Collection javaFiles = FileUtils.listFiles((File)rootFolder, (String[])new String[]{"java"}, (boolean)true);
        for (File javaFile : javaFiles) {
            Resource resource = this.parseResource(javaFile, rs);
            if (resource != null) {
                resources.add(resource);
                continue;
            }
            logger.warn((Object)("Failed to load resource: " + javaFile));
        }
        return resources;
    }

    private Resource parseResource(File file, ResourceSet rs) throws IOException {
        return this.loadResource(file.getCanonicalPath(), rs);
    }

    private Resource loadResource(String filePath, ResourceSet rs) throws IOException {
        return this.loadResource(URI.createFileURI((String)filePath), rs);
    }

    private Resource loadResource(URI uri, ResourceSet rs) throws IOException {
        return rs.getResource(uri, true);
    }

    private ResourceSet setUpResourceSet(String sourceModelDirectory, List<String> jarPaths, boolean extractLayoutInfo) {
        ArrayList directories = Lists.newArrayList();
        if (sourceModelDirectory != null) {
            directories.add(sourceModelDirectory);
        }
        SPLevoResourceSet rs = new SPLevoResourceSet();
        JaMoPPSoftwareModelExtractor.initResourceSet((ResourceSet)rs, directories, extractLayoutInfo, jarPaths);
        return rs;
    }

    public String getId() {
        return EXTRACTOR_ID;
    }

    public String getLabel() {
        return EXTRACTOR_LABEL;
    }

    public void prepareResourceSet(ResourceSet rs, List<String> sourceModelPaths, boolean loadLayoutInformation) {
        JaMoPPSoftwareModelExtractor.initResourceSet(rs, sourceModelPaths, loadLayoutInformation, null);
    }

    private static void initResourceSet(ResourceSet rs, List<String> sourceModelPaths, boolean loadLayoutInformation, List<String> jarPaths) {
        Boolean disableLayoutOption = loadLayoutInformation ? Boolean.FALSE : Boolean.TRUE;
        Map options = rs.getLoadOptions();
        options.put("OPTION_USE_LOCAL_CLASSPATH", Boolean.TRUE);
        options.put("OPTION_REGISTER_STD_LIB", Boolean.TRUE);
        options.put("DISABLE_EMF_VALIDATION", Boolean.TRUE);
        options.put("DISABLE_LAYOUT_INFORMATION_RECORDING", disableLayoutOption);
        options.put("DISABLE_LOCATION_MAP", disableLayoutOption);
        options.put(FileResourceHandling.ResourceHandlingOptions.USE_PLATFORM_RESOURCE, FileResourceHandling.ResourceHandlingOptions.USE_PLATFORM_RESOURCE.getDefault());
        JavaSourceOrClassFileResourceFactoryImpl originalFactory = new JavaSourceOrClassFileResourceFactoryImpl();
        JavaSourceOrClassFileResourceCachingFactoryImpl cachedJaMoPPFactory = new JavaSourceOrClassFileResourceCachingFactoryImpl((Resource.Factory)originalFactory, sourceModelPaths, JavaClasspath.get((ResourceSet)rs), jarPaths);
        Map factoryMap = rs.getResourceFactoryRegistry().getExtensionToFactoryMap();
        factoryMap.put("java", cachedJaMoPPFactory);
        factoryMap.put("class", originalFactory);
    }
}

