/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.extraction.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.splevo.jamopp.extraction.cache.ReferenceCacheData;

public class ReferenceCache {
    public static final String CACHE_FILE_NAME = "jamopp.cache";
    private static Logger logger = Logger.getLogger(ReferenceCache.class);
    private int notResolvedFromCacheCounterReference = 0;
    private final Set<URI> blacklistedResourceURIs = Sets.newHashSet();
    private final List<String> cacheFileDirectories;
    private ReferenceCacheData cacheData = new ReferenceCacheData();

    public ReferenceCache(List<String> cacheFileDirectories) {
        this.cacheFileDirectories = cacheFileDirectories;
        this.init();
    }

    private void init() {
        for (String cacheDirectory : this.cacheFileDirectories) {
            ReferenceCacheData loadedCacheData;
            File cacheFile = new File(String.valueOf(cacheDirectory) + File.separator + CACHE_FILE_NAME);
            if (!cacheFile.exists() || !cacheFile.canRead() || (loadedCacheData = this.load(cacheFile)) == null) continue;
            this.cacheData.merge(loadedCacheData);
        }
    }

    public void resolve(Resource resource) {
        EcoreUtil.resolveAll((Resource)resource);
    }

    public void save() {
        if (this.cacheFileDirectories == null || this.cacheFileDirectories.size() < 1 || this.cacheFileDirectories.get(0) == null) {
            logger.warn((Object)"No cache file directory(ies) configured");
            return;
        }
        File cacheFile = new File(String.valueOf(this.cacheFileDirectories.get(0)) + File.separator + CACHE_FILE_NAME);
        ReferenceCacheData cacheDataExisting = this.load(cacheFile);
        if (cacheDataExisting == null) {
            cacheDataExisting = new ReferenceCacheData();
            this.cacheData.merge(cacheDataExisting);
        }
        this.save(cacheFile, this.cacheData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void save(File cacheFile, ReferenceCacheData cacheData) {
        ObjectOutputStream oos = null;
        try {
            try {
                FileUtils.forceMkdir((File)cacheFile.getParentFile());
                oos = new ObjectOutputStream(new FileOutputStream(cacheFile));
                oos.writeObject(cacheData);
                return;
            }
            catch (FileNotFoundException e) {
                logger.info((Object)("cache file does not exist yet" + cacheFile));
                if (oos == null) return;
                try {
                    oos.close();
                    return;
                }
                catch (IOException e2) {
                    logger.warn((Object)"Failed to close cache file output stream", (Throwable)e2);
                }
                return;
            }
            catch (IOException e) {
                logger.warn((Object)("cache file could not be accessed: " + cacheFile));
                if (oos == null) return;
                try {
                    oos.close();
                    return;
                }
                catch (IOException e3) {
                    logger.warn((Object)"Failed to close cache file output stream", (Throwable)e3);
                }
                return;
            }
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    logger.warn((Object)"Failed to close cache file output stream", (Throwable)e);
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ReferenceCacheData load(File cacheFile) {
        if (!cacheFile.exists() && !cacheFile.canRead()) {
            return null;
        }
        logger.debug((Object)("Load reference cache file: " + cacheFile.getAbsolutePath()));
        ReferenceCacheData cacheDataLoad = null;
        ObjectInputStream oos = null;
        try {
            try {
                oos = new ObjectInputStream(new FileInputStream(cacheFile));
                cacheDataLoad = (ReferenceCacheData)oos.readObject();
                return cacheDataLoad;
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"Cache file can not be found", (Throwable)e);
                if (oos == null) return cacheDataLoad;
                try {
                    oos.close();
                    return cacheDataLoad;
                }
                catch (IOException e2) {
                    logger.warn((Object)"Failed to close cache file output stream", (Throwable)e2);
                }
                return cacheDataLoad;
            }
            catch (IOException e) {
                logger.error((Object)"Cache file could not be accessed correctly", (Throwable)e);
                if (oos == null) return cacheDataLoad;
                try {
                    oos.close();
                    return cacheDataLoad;
                }
                catch (IOException e3) {
                    logger.warn((Object)"Failed to close cache file output stream", (Throwable)e3);
                }
                return cacheDataLoad;
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)"An object persisted in the cache file could not be loaded", (Throwable)e);
                if (oos == null) return cacheDataLoad;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    oos.close();
                    return cacheDataLoad;
                }
                catch (IOException e4) {
                    logger.warn((Object)"Failed to close cache file output stream", (Throwable)e4);
                }
                return cacheDataLoad;
            }
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    logger.warn((Object)"Failed to close cache file output stream", (Throwable)e);
                }
            }
        }
    }

    private EObject getTarget(Resource resource, String targetURI) {
        URI createURI = URI.createURI((String)targetURI);
        ResourceSet resourceSet = resource.getResourceSet();
        EObject target = resourceSet.getEObject(createURI, true);
        return target;
    }

    public int getNotResolvedFromCacheCounterReference() {
        return this.notResolvedFromCacheCounterReference;
    }

    public EObject getEObject(Resource resource, String id) {
        String resourceUri = resource.getURI().toString();
        LinkedHashMap<String, String> targetUriMap = this.cacheData.getResourceToTargetURIListMap().get(resourceUri);
        if (targetUriMap == null) {
            return null;
        }
        String targetURI = targetUriMap.get(id);
        if (targetURI == null) {
            return null;
        }
        return this.getTarget(resource, targetURI);
    }

    public boolean isCached(Resource resource) {
        return this.cacheData.getResourceToTargetURIListMap().containsKey(resource.getURI().toString());
    }

    public void registerEObject(Resource resource, String fragmentURI, EObject resolvedElement) {
        String targetURI;
        if (resolvedElement != null && resolvedElement.eResource() != null && resolvedElement.eResource().getURI() != null && this.blacklistedResourceURIs.contains(resolvedElement.eResource().getURI())) {
            return;
        }
        String resourceUri = resource.getURI().toString();
        if (resolvedElement == null) {
            logger.warn((Object)String.format("Tried to register a null element in the cache %s#%s", resourceUri, fragmentURI));
            return;
        }
        if (resolvedElement.eIsProxy() && this.isNotLibraryProxy(resolvedElement)) {
            logger.warn((Object)String.format("Tried to register a non-library proxy in the cache: %s#%s", resourceUri, fragmentURI));
            return;
        }
        Resource targetResource = resolvedElement.eResource();
        if (targetResource != null) {
            targetURI = String.valueOf(targetResource.getURI().toString()) + "#" + targetResource.getURIFragment(resolvedElement);
        } else if (resolvedElement.eIsProxy()) {
            targetURI = ((InternalEObject)resolvedElement).eProxyURI().toString();
        } else {
            logger.error((Object)("Unable to identify target URI of resolved element: " + resolvedElement));
            return;
        }
        LinkedHashMap targetURIMap = this.cacheData.getResourceToTargetURIListMap().get(resourceUri);
        if (targetURIMap == null) {
            targetURIMap = Maps.newLinkedHashMap();
            this.cacheData.getResourceToTargetURIListMap().put(resourceUri, targetURIMap);
        }
        targetURIMap.put(fragmentURI, targetURI);
        ++this.notResolvedFromCacheCounterReference;
    }

    private boolean isNotLibraryProxy(EObject resolvedElement) {
        return !"pathmap".equals(((InternalEObject)resolvedElement).eProxyURI().scheme());
    }

    public void reset(Resource resource) {
        if (!this.isCached(resource)) {
            return;
        }
        String uriToRemovePrefix = String.valueOf(resource.getURI().toString()) + "#";
        this.cacheData.getResourceToTargetURIListMap().remove(resource.getURI().toString());
        for (LinkedHashMap<String, String> map : this.cacheData.getResourceToTargetURIListMap().values()) {
            ArrayList toRemove = Lists.newArrayList();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!entry.getValue().startsWith(uriToRemovePrefix)) continue;
                toRemove.add(entry.getKey());
            }
            map.keySet().removeAll(toRemove);
        }
        this.save();
    }

    public void blacklist(Resource resource) {
        this.reset(resource);
        this.blacklistedResourceURIs.add(resource.getURI());
    }
}

