/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.refactoring.tests;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.emftext.language.java.commons.Commentable;
import org.emftext.language.java.containers.CompilationUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.jamopp.refactoring.JaMoPPResourceProcessor;
import org.splevo.jamopp.refactoring.tests.JaMoPPRefactoringsTestUtils;
import org.splevo.jamopp.vpm.software.CommentableSoftwareElement;
import org.splevo.jamopp.vpm.software.JaMoPPSoftwareElement;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;

public class JaMoPPResourceProcessorTest {
    private static final JaMoPPRefactoringsTestUtils TEST_UTILS = new JaMoPPRefactoringsTestUtils();
    private JaMoPPResourceProcessor subject;

    @BeforeClass
    public static void init() {
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
    }

    @Before
    public void setUp() {
        this.subject = new JaMoPPResourceProcessor();
    }

    @Test
    public void testProcessResourcesBeforeRefactoring() throws Exception {
        VariationPointModel vpm = TEST_UTILS.getVariantsWithComments(false);
        EcoreUtil.resolveAll((EObject)vpm);
        for (SoftwareElement se : vpm.getSoftwareElements()) {
            Commentable c = (Commentable)se.getWrappedElement();
            Assert.assertNotNull((Object)c.getLayoutInformations());
            Assert.assertEquals((long)0L, (long)c.getLayoutInformations().size());
        }
        HashSet resources = Sets.newHashSet((Iterable)Iterables.transform((Iterable)vpm.getSoftwareElements(), (Function)new Function<SoftwareElement, Resource>(){

            public Resource apply(SoftwareElement input) {
                return input.getWrappedElement().eResource();
            }
        }));
        for (Resource r : resources) {
            this.subject.processBeforeRefactoring(r);
        }
        EcoreUtil.resolveAll((EObject)vpm);
        for (SoftwareElement se : vpm.getSoftwareElements()) {
            Commentable c = (Commentable)se.getWrappedElement();
            Assert.assertNotNull((Object)c.getLayoutInformations());
            Assert.assertNotEquals((long)0L, (long)c.getLayoutInformations().size());
        }
    }

    @Test
    public void testProcessVPMAfterRefactoring() throws Exception {
        VariationPointModel vpm = TEST_UTILS.getVariantsWithComments(true);
        HashMap expected = Maps.newHashMap();
        for (VariationPointGroup vpg : vpm.getVariationPointGroups()) {
            for (VariationPoint vp : vpg.getVariationPoints()) {
                expected.put(vp, Lists.newArrayList((Object[])new EObject[]{vp.getLocation().getWrappedElement()}));
                for (Variant v : vp.getVariants()) {
                    expected.put(v, Iterables.transform((Iterable)v.getImplementingElements(), (Function)new Function<SoftwareElement, EObject>(){

                        public EObject apply(SoftwareElement input) {
                            return input.getWrappedElement();
                        }
                    }));
                }
            }
        }
        this.subject.processVPMAfterRefactorings(vpm);
        for (SoftwareElement se : vpm.getSoftwareElements()) {
            if (se.getWrappedElement() instanceof CompilationUnit) {
                Assert.assertThat((Object)se, (Matcher)IsInstanceOf.instanceOf(JaMoPPSoftwareElement.class));
                continue;
            }
            Assert.assertThat((Object)se, (Matcher)IsInstanceOf.instanceOf(CommentableSoftwareElement.class));
        }
        for (VariationPointGroup vpg : vpm.getVariationPointGroups()) {
            for (VariationPoint vp : vpg.getVariationPoints()) {
                ArrayList actualVPLocation = Lists.newArrayList((Object[])new EObject[]{vp.getLocation().getWrappedElement()});
                Object[] expectedVPLocation = (EObject[])Iterables.toArray((Iterable)((Iterable)expected.get(vp)), EObject.class);
                Assert.assertThat((Object)actualVPLocation, (Matcher)IsCollectionContaining.hasItems((Object[])expectedVPLocation));
                for (Variant v : vp.getVariants()) {
                    Iterable actual = Iterables.transform((Iterable)v.getImplementingElements(), (Function)new Function<SoftwareElement, EObject>(){

                        public EObject apply(SoftwareElement input) {
                            return input.getWrappedElement();
                        }
                    });
                    Assert.assertThat((Object)Iterables.size((Iterable)actual), (Matcher)IsEqual.equalTo((Object)Iterables.size((Iterable)((Iterable)expected.get(v)))));
                    Assert.assertThat((Object)actual, (Matcher)IsCollectionContaining.hasItems((Object[])((EObject[])Iterables.toArray((Iterable)((Iterable)expected.get(v)), EObject.class))));
                }
            }
        }
    }
}

