/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.refactoring.tests.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.splevo.commons.emf.SPLevoResourceSet;
import org.splevo.jamopp.diffing.JaMoPPDiffer;
import org.splevo.jamopp.extraction.JaMoPPSoftwareModelExtractor;
import org.splevo.jamopp.vpm.builder.JaMoPPVPMBuilder;
import org.splevo.vpm.VPMUtil;
import org.splevo.vpm.refinement.Refinement;
import org.splevo.vpm.refinement.RefinementFactory;
import org.splevo.vpm.refinement.RefinementType;
import org.splevo.vpm.refinement.VPMRefinementService;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointModel;

public abstract class RefactoringTestUtilsBase {
    protected abstract String getBasePath();

    private String getPathFromFolderName(String folderName, boolean leading) {
        return String.valueOf(this.getBasePath()) + folderName + (leading ? "/leading/" : "/integration/");
    }

    protected VariationPointModel initializeVariationPointModel(String folderName, boolean layoutInformation) throws Exception {
        String leadingPath = this.getPathFromFolderName(folderName, true);
        String integrationPath = this.getPathFromFolderName(folderName, false);
        final File tmpDir = Files.createTempDir();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                FileUtils.deleteQuietly((File)tmpDir);
            }
        }));
        File tmpLeading = new File(tmpDir, "leading");
        File tmpIntegration = new File(tmpDir, "integration");
        FileUtils.copyDirectory((File)new File(leadingPath), (File)tmpLeading);
        FileUtils.copyDirectory((File)new File(integrationPath), (File)tmpIntegration);
        JaMoPPSoftwareModelExtractor extractor = new JaMoPPSoftwareModelExtractor();
        ArrayList urisA = Lists.newArrayList((Object[])new String[]{tmpLeading.getAbsolutePath()});
        ArrayList urisB = Lists.newArrayList((Object[])new String[]{tmpIntegration.getAbsolutePath()});
        NullProgressMonitor monitor = new NullProgressMonitor();
        ResourceSet setA = extractor.extractSoftwareModel((List)urisA, (IProgressMonitor)monitor, null, layoutInformation);
        ResourceSet setB = extractor.extractSoftwareModel((List)urisB, (IProgressMonitor)monitor, null, layoutInformation);
        String ignorePackages = RefactoringTestUtilsBase.buildIgnorePackages();
        LinkedHashMap diffOptions = Maps.newLinkedHashMap();
        diffOptions.put("JaMoPP.Java.Packages.to.ignore", ignorePackages);
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(setA, setB, (Map)diffOptions);
        JaMoPPVPMBuilder builder = new JaMoPPVPMBuilder();
        VariationPointModel vpm = builder.buildVPM(comparison, "leading", "integration");
        File tmpVpm = new File(tmpDir, "tmp.vpm");
        VPMUtil.save((VariationPointModel)vpm, (URI)URI.createFileURI((String)tmpVpm.getAbsolutePath()));
        SPLevoResourceSet rs = new SPLevoResourceSet();
        extractor.prepareResourceSet((ResourceSet)rs, (List)Lists.newArrayList((Object[])new String[]{tmpLeading.getAbsolutePath(), tmpIntegration.getAbsolutePath()}), layoutInformation);
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("vpm", new XMIResourceFactoryImpl());
        Resource vpmResource = rs.createResource(URI.createFileURI((String)tmpVpm.getAbsolutePath()));
        vpmResource.load(Collections.EMPTY_MAP);
        return (VariationPointModel)vpmResource.getContents().get(0);
    }

    private static String buildIgnorePackages() {
        StringBuilder sb = new StringBuilder();
        sb.append("java.*");
        sb.append(System.getProperty("line.separator"));
        String ignorePackages = sb.toString();
        return ignorePackages;
    }

    protected static void performRefinement(VariationPointModel vpm, RefinementType refinementType, VariationPoint ... variationPoints) {
        Refinement refinement = RefinementFactory.eINSTANCE.createRefinement();
        refinement.setType(refinementType);
        VariationPoint[] variationPointArray = variationPoints;
        int n = variationPoints.length;
        int n2 = 0;
        while (n2 < n) {
            VariationPoint variationPoint = variationPointArray[n2];
            refinement.getVariationPoints().add((Object)variationPoint);
            ++n2;
        }
        VPMRefinementService refinementService = new VPMRefinementService();
        refinementService.applyRefinements((List)Lists.newArrayList((Object[])new Refinement[]{refinement}), vpm);
    }
}

