/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.refactoring;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.emftext.language.java.commons.Commentable;
import org.emftext.language.java.containers.CompilationUnit;
import org.emftext.language.java.resource.java.IJavaTextResource;
import org.splevo.commons.emf.CachingResource;
import org.splevo.commons.emf.ReplacementUtil;
import org.splevo.jamopp.refactoring.util.RefactoringUtil;
import org.splevo.jamopp.vpm.software.CommentableSoftwareElement;
import org.splevo.jamopp.vpm.software.JaMoPPSoftwareElement;
import org.splevo.jamopp.vpm.software.softwareFactory;
import org.splevo.refactoring.ResourceProcessor;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointModel;

public class JaMoPPResourceProcessor
implements ResourceProcessor {
    private static final Logger LOGGER = Logger.getLogger(JaMoPPResourceProcessor.class);

    public void processBeforeRefactoring(Resource resource) {
        if (resource instanceof CachingResource) {
            ((CachingResource)resource).disableCaching();
        }
        if (resource instanceof IJavaTextResource) {
            this.reloadResourceWithLayoutInformation(resource);
        }
    }

    public void processVPMBeforeRefactoring(VariationPointModel variationPointModel) {
    }

    private void replaceCommentableSoftwareElementWithJaMoPPSoftwareElement(CommentableSoftwareElement oldSoftwareElement) {
        Commentable referencedElement = oldSoftwareElement.getJamoppElement();
        RefactoringUtil.removeCommentableSoftwareElementReference(oldSoftwareElement);
        this.saveJaMoPPModel(oldSoftwareElement.eResource());
        JaMoPPSoftwareElement newSoftwareElement = softwareFactory.eINSTANCE.createJaMoPPSoftwareElement();
        newSoftwareElement.setJamoppElement(referencedElement);
        JaMoPPResourceProcessor.replaceReferences((SoftwareElement)oldSoftwareElement, (SoftwareElement)newSoftwareElement);
    }

    private void replaceJaMoPPSoftwareElementWithCommentableSoftwareElement(JaMoPPSoftwareElement oldSoftwareElement) {
        Commentable referencedElement = oldSoftwareElement.getJamoppElement();
        if (referencedElement instanceof CompilationUnit) {
            return;
        }
        String elementID = RefactoringUtil.addCommentableSoftwareElementReference(referencedElement);
        this.saveJaMoPPModel(referencedElement.eResource());
        CommentableSoftwareElement newSoftwareElement = RefactoringUtil.createCommentableSoftwareElement(referencedElement, elementID);
        JaMoPPResourceProcessor.replaceReferences((SoftwareElement)oldSoftwareElement, (SoftwareElement)newSoftwareElement);
    }

    private static void replaceReferences(SoftwareElement oldSoftwareElement, SoftwareElement newSoftwareElement) {
        Resource vpmResource = oldSoftwareElement.eResource();
        EcoreUtil.replace((EObject)oldSoftwareElement, (EObject)newSoftwareElement);
        ReplacementUtil.replaceCrossReferences((EObject)oldSoftwareElement, (EObject)newSoftwareElement, (ResourceSet[])new ResourceSet[]{vpmResource.getResourceSet()});
    }

    private void saveJaMoPPModel(Resource eResource) {
        try {
            eResource.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void processAfterRefactoring(Resource resource) {
    }

    private void reloadResourceWithLayoutInformation(Resource resource) {
        Map options = resource.getResourceSet().getLoadOptions();
        options.put("DISABLE_LAYOUT_INFORMATION_RECORDING", Boolean.FALSE);
        options.put("DISABLE_LOCATION_MAP", Boolean.FALSE);
        try {
            resource.unload();
            resource.load(options);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Could not preprocess JaMoPP resource.", (Throwable)e);
        }
    }

    public void processVPMAfterRefactorings(VariationPointModel variationPointModel) {
        for (JaMoPPSoftwareElement se : Iterables.filter((Iterable)variationPointModel.getSoftwareElements(), JaMoPPSoftwareElement.class)) {
            this.replaceJaMoPPSoftwareElementWithCommentableSoftwareElement(se);
        }
    }

    public void processVPBeforeFullyAutomatedRefactoring(VariationPoint variationPoint) {
        HashSet softwareElements = Sets.newHashSet((Object[])new SoftwareElement[]{variationPoint.getLocation()});
        for (Variant variant : variationPoint.getVariants()) {
            softwareElements.addAll(variant.getImplementingElements());
        }
        for (CommentableSoftwareElement se : Iterables.filter((Iterable)softwareElements, CommentableSoftwareElement.class)) {
            this.replaceCommentableSoftwareElementWithJaMoPPSoftwareElement(se);
        }
    }
}

