/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.refactoring.java;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.emftext.language.java.commons.Commentable;
import org.splevo.jamopp.vpm.software.JaMoPPSoftwareElement;
import org.splevo.jamopp.vpm.software.softwareFactory;
import org.splevo.refactoring.FullyAutomatedVariabilityRefactoring;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;

public abstract class JaMoPPFullyAutomatedVariabilityRefactoring
extends FullyAutomatedVariabilityRefactoring {
    private static final Logger LOGGER = Logger.getLogger(JaMoPPFullyAutomatedVariabilityRefactoring.class);

    protected SoftwareElement createSoftwareElement(EObject eobject) {
        if (!(eobject instanceof Commentable)) {
            LOGGER.error((Object)("The given EObject is no Commentable, but a " + eobject.getClass().getSimpleName() + "."));
            return null;
        }
        Commentable element = (Commentable)eobject;
        JaMoPPSoftwareElement jse = softwareFactory.eINSTANCE.createJaMoPPSoftwareElement();
        jse.setJamoppElement(element);
        return jse;
    }

    protected void executeReplacement(Map.Entry<EObject, EObject> replacement, VariationPoint variationPoint) {
        Iterable softwareElements = Iterables.concat((Iterable)Iterables.transform((Iterable)variationPoint.getVariants(), (Function)new Function<Variant, Iterable<SoftwareElement>>(){

            public Iterable<SoftwareElement> apply(Variant input) {
                return input.getImplementingElements();
            }
        }));
        if (!this.executeReplacement(replacement, softwareElements)) {
            super.executeReplacement(replacement, variationPoint);
        }
    }

    private boolean executeReplacement(Map.Entry<EObject, EObject> replacement, Iterable<SoftwareElement> softwareElements) {
        if (!(replacement.getKey() instanceof Commentable) || !(replacement.getValue() instanceof Commentable)) {
            return false;
        }
        for (SoftwareElement se : softwareElements) {
            if (se.getWrappedElement() != replacement.getKey()) continue;
            if (!(se instanceof JaMoPPSoftwareElement)) {
                return false;
            }
            LOGGER.debug((Object)String.format("Replaced %s with %s.", replacement.getKey(), replacement.getValue()));
            JaMoPPSoftwareElement jse = (JaMoPPSoftwareElement)se;
            jse.setJamoppElement((Commentable)replacement.getValue());
        }
        return true;
    }
}

