/*
 * Decompiled with CFR 0.152.
 */
package org.emftext.language.java.extensions.members;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.emftext.language.java.arrays.ArrayTypeable;
import org.emftext.language.java.classifiers.ConcreteClassifier;
import org.emftext.language.java.expressions.Expression;
import org.emftext.language.java.instantiations.NewConstructorCall;
import org.emftext.language.java.members.Constructor;
import org.emftext.language.java.parameters.Parameter;
import org.emftext.language.java.parameters.VariableLengthParameter;
import org.emftext.language.java.references.Reference;
import org.emftext.language.java.types.Type;
import org.emftext.language.java.types.TypeReference;

public class ConstructorExtension {
    public static boolean isBetterConstructorForCall(Constructor co, Constructor other, NewConstructorCall call) {
        if (ConstructorExtension.isConstructorForCall(other, call, true)) {
            return false;
        }
        if (ConstructorExtension.isConstructorForCall(other, call, false)) {
            return ConstructorExtension.isConstructorForCall(co, call, true);
        }
        return ConstructorExtension.isConstructorForCall(co, call, false);
    }

    public static boolean isConstructorForCall(Constructor co, NewConstructorCall call, boolean needsPerfectMatch) {
        Type callType = call.getReferencedType();
        if (callType instanceof ConcreteClassifier) {
            if (!((ConcreteClassifier)callType).getMembers().contains((Object)co)) {
                return false;
            }
        } else {
            return false;
        }
        EList argumentTypeList = call.getArgumentTypes();
        BasicEList parameterList = new BasicEList((Collection)co.getParameters());
        BasicEList parameterTypeList = new BasicEList();
        for (Parameter parameter : parameterList) {
            TypeReference typeReference = parameter.getTypeReference();
            Type boundTarget = typeReference.getBoundTarget((Reference)call);
            parameterTypeList.add((Object)boundTarget);
        }
        if (!parameterList.isEmpty()) {
            Parameter lastParameter = (Parameter)parameterList.get(parameterList.size() - 1);
            Type lastParameterType = (Type)parameterTypeList.get(parameterTypeList.size() - 1);
            if (lastParameter instanceof VariableLengthParameter) {
                while (parameterList.size() < argumentTypeList.size()) {
                    if (needsPerfectMatch) {
                        return false;
                    }
                    parameterList.add((Object)lastParameter);
                    parameterTypeList.add((Object)lastParameterType);
                }
                if (parameterList.size() > argumentTypeList.size()) {
                    if (needsPerfectMatch) {
                        return false;
                    }
                    parameterList.remove((Object)lastParameter);
                    parameterTypeList.remove(parameterTypeList.size() - 1);
                }
            }
        }
        if (parameterList.size() == argumentTypeList.size()) {
            boolean parametersMatch = true;
            int i = 0;
            while (i < argumentTypeList.size()) {
                Parameter parameter = (Parameter)parameterList.get(i);
                Expression argument = (Expression)call.getArguments().get(i);
                Type parameterType = (Type)parameterTypeList.get(i);
                Type argumentType = (Type)argumentTypeList.get(i);
                if (argumentType == null || parameterType == null) {
                    return false;
                }
                if (!parameterType.eIsProxy() || !argumentType.eIsProxy()) {
                    long argumentArrayDimension = argument.getArrayDimension();
                    if (needsPerfectMatch) {
                        long parameterArrayDimension = parameter.getArrayDimension();
                        parametersMatch = parametersMatch && argumentType.equalsType(argumentArrayDimension, parameterType, parameterArrayDimension);
                    } else {
                        parametersMatch = parametersMatch && argumentType.isSuperType(argumentArrayDimension, parameterType, (ArrayTypeable)parameter);
                    }
                } else {
                    return false;
                }
                ++i;
            }
            return parametersMatch;
        }
        return false;
    }
}

