/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.util;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ComposedSwitch;
import org.eclipse.emf.ecore.util.Switch;
import org.emftext.language.java.classifiers.Classifier;
import org.emftext.language.java.classifiers.ConcreteClassifier;
import org.emftext.language.java.classifiers.Enumeration;
import org.emftext.language.java.classifiers.Interface;
import org.emftext.language.java.classifiers.util.ClassifiersSwitch;
import org.emftext.language.java.commons.Commentable;
import org.emftext.language.java.commons.CommonsPackage;
import org.emftext.language.java.commons.NamedElement;
import org.emftext.language.java.containers.CompilationUnit;
import org.emftext.language.java.containers.JavaRoot;
import org.emftext.language.java.containers.util.ContainersSwitch;
import org.emftext.language.java.expressions.Expression;
import org.emftext.language.java.extensions.members.ConstructorExtension;
import org.emftext.language.java.imports.ClassifierImport;
import org.emftext.language.java.imports.Import;
import org.emftext.language.java.instantiations.NewConstructorCall;
import org.emftext.language.java.members.AdditionalField;
import org.emftext.language.java.members.Constructor;
import org.emftext.language.java.members.Field;
import org.emftext.language.java.members.Method;
import org.emftext.language.java.members.util.MembersSwitch;
import org.emftext.language.java.parameters.Parameter;
import org.emftext.language.java.references.MethodCall;
import org.emftext.language.java.statements.Block;
import org.emftext.language.java.statements.ExpressionStatement;
import org.emftext.language.java.statements.LocalVariableStatement;
import org.emftext.language.java.statements.Return;
import org.emftext.language.java.statements.Statement;
import org.emftext.language.java.statements.StatementListContainer;
import org.emftext.language.java.statements.TryBlock;
import org.emftext.language.java.types.Type;
import org.emftext.language.java.variables.AdditionalLocalVariable;
import org.emftext.language.java.variables.LocalVariable;

public final class JaMoPPElementUtil {
    private JaMoPPElementUtil() {
    }

    public static EObject getFirstContainerNotOfGivenType(Commentable element, final Class<?> ... ignoredContainerTypes) {
        Predicate<EObject> matchingPredicate = new Predicate<EObject>(){

            public boolean apply(EObject container) {
                Class[] classArray = ignoredContainerTypes;
                int n = ignoredContainerTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    Class clazz = classArray[n2];
                    if (clazz.isAssignableFrom(container.getClass())) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        };
        return JaMoPPElementUtil.getTransitiveContainerForPredicate(element, matchingPredicate);
    }

    private static EObject getTransitiveContainerForPredicate(Commentable element, Predicate<EObject> predicate) {
        EObject container = element.eContainer();
        while (!predicate.apply((Object)container)) {
            container = container.eContainer();
        }
        return container;
    }

    public static boolean isParentOf(Commentable parentCandidate, Commentable child) {
        Commentable container = child;
        while (container != null) {
            if (container == parentCandidate) {
                return true;
            }
            container = container.eContainer();
        }
        return false;
    }

    public static String getName(Commentable element) {
        if (element == null) {
            return null;
        }
        if (element instanceof NamedElement) {
            return ((NamedElement)element).getName();
        }
        return null;
    }

    public static String getLabel(Commentable element) {
        if (element == null) {
            return "NULL";
        }
        if (element instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)element;
            String name = cu.getName();
            if (name != null) {
                return name.substring(cu.getNamespacesAsString().length());
            }
            return "CompilationUnit (no name)";
        }
        if (element instanceof LocalVariableStatement) {
            LocalVariableStatement statement = (LocalVariableStatement)element;
            LocalVariable variable = statement.getVariable();
            StringBuilder labelBuilder = new StringBuilder("Variable Declaration (");
            labelBuilder.append(variable.getName());
            for (AdditionalLocalVariable addVar : variable.getAdditionalLocalVariables()) {
                labelBuilder.append(", ");
                labelBuilder.append(addVar.getName());
            }
            labelBuilder.append(") :");
            return labelBuilder.toString();
        }
        if (element instanceof ExpressionStatement) {
            ExpressionStatement statement = (ExpressionStatement)element;
            Expression expression = statement.getExpression();
            if (expression.getType() != null) {
                String expressionType = statement.getExpression().getType().getClass().getSimpleName();
                if (expressionType.endsWith("Impl")) {
                    expressionType = expressionType.substring(0, expressionType.length() - 4);
                }
                return String.format("Expression Statement (%s)", expressionType);
            }
            return "Expression Statement (void)";
        }
        if (element instanceof Return) {
            return "Return Statement";
        }
        if (element instanceof ClassifierImport) {
            ClassifierImport importDecl = (ClassifierImport)element;
            return "Import: " + importDecl.getClassifier().getName();
        }
        if (element instanceof Import) {
            return "Import";
        }
        if (element instanceof MethodCall) {
            MethodCall invocation = (MethodCall)element;
            return "Method Invocation: " + invocation.getTarget().getName() + "()";
        }
        if (element instanceof Method) {
            Method method = (Method)element;
            return String.valueOf(method.getName()) + "()";
        }
        if (element instanceof Constructor) {
            Constructor method = (Constructor)element;
            return String.valueOf(method.getName()) + "()";
        }
        if (element instanceof Block && JaMoPPElementUtil.getContainingMethod(element) != null) {
            Method method = JaMoPPElementUtil.getContainingMethod(element);
            return String.valueOf(method.getName()) + "()";
        }
        if (element instanceof TryBlock) {
            String containerName = null;
            containerName = element.eContainer() instanceof Commentable ? JaMoPPElementUtil.getLabel((Commentable)element.eContainer()) : "" + element.eContainer();
            return "try-Block in " + containerName;
        }
        if (element instanceof NamedElement) {
            return ((NamedElement)element).getName();
        }
        return "JaMoPP Element " + element.getClass().getSimpleName();
    }

    public static String getQualifiedName(Commentable commentable) {
        String result = new QualifiedNameSwitch().doSwitch((EObject)commentable);
        return result;
    }

    private static Method getContainingMethod(Commentable element) {
        EObject container = element.eContainer();
        while (container != null) {
            if (container instanceof Method) {
                return (Method)container;
            }
            container = container.eContainer();
        }
        return null;
    }

    public static int getPositionInContainer(Statement statement) {
        if (statement.eContainer() instanceof StatementListContainer) {
            StatementListContainer container = (StatementListContainer)statement.eContainer();
            return container.getStatements().indexOf((Object)statement);
        }
        return -1;
    }

    public static Import checkForImport(Commentable referenceElement, Type type) {
        CompilationUnit cu = referenceElement.getContainingCompilationUnit();
        EList imports = cu.getChildrenByType(ClassifierImport.class);
        for (ClassifierImport importDecl : imports) {
            if (!importDecl.getClassifier().equals(type)) continue;
            return importDecl;
        }
        return null;
    }

    public static String getTypeLabel(Commentable element) {
        if (element instanceof Enumeration) {
            return "Enumeration";
        }
        if (element instanceof org.emftext.language.java.classifiers.Class) {
            return "Class";
        }
        if (element instanceof Interface) {
            return "Interface";
        }
        if (element instanceof Field || element instanceof AdditionalField) {
            return "Field";
        }
        if (element instanceof Method || element instanceof Constructor) {
            return "Method";
        }
        if (element instanceof Statement) {
            return "Statement";
        }
        if (element instanceof LocalVariable || element instanceof AdditionalLocalVariable) {
            return "Variable";
        }
        if (element instanceof Parameter) {
            return "Parameter";
        }
        if (element instanceof ClassifierImport) {
            return JaMoPPElementUtil.getTypeLabel((Commentable)((ClassifierImport)element).getClassifier());
        }
        int implLength = 4;
        String className = element.getClass().getSimpleName();
        return className.substring(0, className.length() - implLength);
    }

    public static Constructor getConstructor(NewConstructorCall call) {
        Type type = call.getReferencedType();
        if (type instanceof ConcreteClassifier) {
            for (Constructor constructor : ((ConcreteClassifier)type).getConstructors()) {
                boolean constructorForCall = ConstructorExtension.isConstructorForCall(constructor, call, true);
                if (!constructorForCall) continue;
                return constructor;
            }
        }
        return null;
    }

    private static class QualifiedNameSwitch
    extends ComposedSwitch<String> {
        public QualifiedNameSwitch() {
            this.addSwitch((Switch)new MembersQualifiedNameSwitch());
            this.addSwitch((Switch)new ClassifiersQualifiedNameSwitch());
            this.addSwitch((Switch)new ContainersQualifiedNameSwitch());
        }

        public String doSwitch(EObject eObject) {
            Optional<NamedElement> containerOptional = QualifiedNameSwitch.findRelevantContainer(eObject);
            if (!containerOptional.isPresent()) {
                return null;
            }
            String containerName = this.doSuperSwitch((EObject)containerOptional.get());
            NamedElement container = (NamedElement)containerOptional.get();
            if (container != eObject) {
                String elementName = eObject.getClass().getSimpleName();
                if (eObject instanceof NamedElement) {
                    elementName = ((NamedElement)eObject).getName();
                }
                return String.format("%s -> %s", containerName, elementName);
            }
            return containerName;
        }

        protected String doSwitch(EClass theEClass, EObject theEObject) {
            LinkedList typesToCheck = Lists.newLinkedList((Iterable)theEClass.getEAllSuperTypes());
            typesToCheck.add(0, theEClass);
            typesToCheck.remove(CommonsPackage.eINSTANCE.getCommentable());
            for (EClass eclass : typesToCheck) {
                String result;
                Switch delegate = this.findDelegate(eclass.getEPackage());
                if (delegate == null || (result = (String)this.delegatedDoSwitch(delegate, eclass, theEObject)) == null) continue;
                return result;
            }
            return (String)this.defaultCase(theEObject);
        }

        private String doSuperSwitch(EObject obj) {
            return (String)super.doSwitch(obj);
        }

        private static Optional<NamedElement> findRelevantContainer(EObject obj) {
            EObject relevantContainer = obj;
            while (relevantContainer != null && !QualifiedNameSwitch.isRelevantContainerObject(relevantContainer)) {
                relevantContainer = relevantContainer.eContainer();
            }
            if (relevantContainer != null && relevantContainer instanceof NamedElement) {
                return Optional.of((Object)((NamedElement)relevantContainer));
            }
            return Optional.absent();
        }

        private static boolean isRelevantContainerObject(final EObject obj) {
            return Iterables.any((Iterable)Lists.newArrayList((Object[])new Class[]{JavaRoot.class, Classifier.class, Method.class, Constructor.class, Field.class}), (Predicate)new Predicate<Class<?>>(){

                public boolean apply(Class<?> input) {
                    return input.isAssignableFrom(obj.getClass());
                }
            });
        }

        private class ClassifiersQualifiedNameSwitch
        extends ClassifiersSwitch<String> {
            private ClassifiersQualifiedNameSwitch() {
            }

            public String caseClassifier(Classifier object) {
                return String.format("%s::%s", QualifiedNameSwitch.this.doSuperSwitch((EObject)object.getContainingCompilationUnit()), object.getName());
            }
        }

        private class ContainersQualifiedNameSwitch
        extends ContainersSwitch<String> {
            private ContainersQualifiedNameSwitch() {
            }

            public String caseJavaRoot(JavaRoot object) {
                String namespaces = object.getNamespacesAsString();
                Matcher m = Pattern.compile(String.valueOf(Pattern.quote(namespaces)) + "(.*?)(\\.java)?").matcher(object.getName());
                if (m.matches()) {
                    return m.group(1);
                }
                return object.getName();
            }
        }

        private class MembersQualifiedNameSwitch
        extends MembersSwitch<String> {
            private MembersQualifiedNameSwitch() {
            }

            public String caseField(Field object) {
                return String.format("%s::%s::%s", QualifiedNameSwitch.this.doSuperSwitch((EObject)object.getContainingCompilationUnit()), object.getContainingConcreteClassifier().getName(), object.getName());
            }

            public String caseMethod(Method object) {
                return String.format("%s::%s::%s()", QualifiedNameSwitch.this.doSuperSwitch((EObject)object.getContainingCompilationUnit()), object.getContainingConcreteClassifier().getName(), object.getName());
            }
        }
    }
}

