/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.analyzer.programdependency.tests;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.jamopp.vpm.analyzer.programdependency.JaMoPPProgramDependencyVPMAnalyzer;
import org.splevo.jamopp.vpm.analyzer.programdependency.tests.TestUtil;
import org.splevo.jamopp.vpm.mergedecider.JaMoPPMergeDecider;
import org.splevo.vpm.analyzer.DefaultVPMAnalyzerService;
import org.splevo.vpm.analyzer.VPMAnalyzerResult;
import org.splevo.vpm.analyzer.graph.VPMGraph;
import org.splevo.vpm.analyzer.mergedecider.MergeDeciderRegistry;
import org.splevo.vpm.analyzer.refinement.BasicDetectionRule;
import org.splevo.vpm.analyzer.refinement.DetectionRule;
import org.splevo.vpm.refinement.Refinement;
import org.splevo.vpm.refinement.RefinementType;

public class MergeDeciderTest {
    private static final String BASE_PATH = "testcode/mergedecider/";
    private Logger logger = Logger.getLogger(MergeDeciderTest.class);

    @BeforeClass
    public static void setUp() {
        TestUtil.initLogging();
    }

    @Before
    @After
    public void clearRegistry() {
        MergeDeciderRegistry.getInstance().clearRegistry();
    }

    @Test
    public void testStatements() throws Exception {
        VPMGraph graph = TestUtil.prepareVPMGraph("testcode/mergedecider/Statements/");
        MergeDeciderRegistry.getInstance().registerElement((Object)new JaMoPPMergeDecider());
        JaMoPPProgramDependencyVPMAnalyzer analyzer = new JaMoPPProgramDependencyVPMAnalyzer();
        VPMAnalyzerResult result = analyzer.analyze(graph);
        DefaultVPMAnalyzerService service = new DefaultVPMAnalyzerService();
        service.createGraphEdges(graph, (List)Lists.newArrayList((Object[])new VPMAnalyzerResult[]{result}));
        ArrayList labels = Lists.newArrayList((Object[])new String[]{analyzer.getRelationshipLabel()});
        BasicDetectionRule rule = new BasicDetectionRule((List)labels, RefinementType.GROUPING);
        ArrayList rules = Lists.newArrayList((Object[])new DetectionRule[]{rule});
        List refinements = service.deriveRefinements(graph, (List)rules, true, true);
        Assert.assertThat((String)"Wrong number of refinements", (Object)refinements.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Wrong number of VPs", (Object)((Refinement)refinements.get(0)).getVariationPoints().size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((String)"Wrong refinement type", (Object)((Refinement)refinements.get(0)).getType(), (Matcher)CoreMatchers.is((Object)RefinementType.MERGE));
    }
}

