/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.analyzer.programdependency.tests;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.splevo.jamopp.diffing.JaMoPPDiffer;
import org.splevo.jamopp.extraction.JaMoPPSoftwareModelExtractor;
import org.splevo.jamopp.vpm.analyzer.programdependency.JaMoPPProgramDependencyVPMAnalyzer;
import org.splevo.jamopp.vpm.analyzer.programdependency.references.DependencyType;
import org.splevo.jamopp.vpm.builder.JaMoPPVPMBuilder;
import org.splevo.vpm.analyzer.DefaultVPMAnalyzerService;
import org.splevo.vpm.analyzer.VPMAnalyzerException;
import org.splevo.vpm.analyzer.VPMAnalyzerResult;
import org.splevo.vpm.analyzer.VPMEdgeDescriptor;
import org.splevo.vpm.analyzer.config.ChoiceConfiguration;
import org.splevo.vpm.analyzer.config.VPMAnalyzerConfigurationSet;
import org.splevo.vpm.analyzer.graph.VPMGraph;
import org.splevo.vpm.variability.VariationPointModel;

public final class TestUtil {
    private TestUtil() {
    }

    public static void initLogging() {
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
    }

    public static VPMGraph prepareVPMGraph(String testBasePath) throws Exception {
        return TestUtil.prepareVPMGraph(String.valueOf(testBasePath) + "a", String.valueOf(testBasePath) + "b");
    }

    public static VPMGraph prepareVPMGraph(String relativePathA, String relativePathB) throws Exception {
        String pathA = new File(relativePathA).getCanonicalPath();
        String pathB = new File(relativePathB).getCanonicalPath();
        JaMoPPSoftwareModelExtractor extractor = new JaMoPPSoftwareModelExtractor();
        ResourceSet setA = extractor.extractSoftwareModel((List)Lists.newArrayList((Object[])new String[]{pathA}), (IProgressMonitor)new NullProgressMonitor());
        ResourceSet setB = extractor.extractSoftwareModel((List)Lists.newArrayList((Object[])new String[]{pathB}), (IProgressMonitor)new NullProgressMonitor());
        JaMoPPDiffer differ = new JaMoPPDiffer();
        LinkedHashMap newLinkedHashMap = Maps.newLinkedHashMap();
        Comparison diff = differ.doDiff(setA, setB, (Map)newLinkedHashMap);
        JaMoPPVPMBuilder builder = new JaMoPPVPMBuilder();
        VariationPointModel vpm = builder.buildVPM(diff, "a", "b");
        DefaultVPMAnalyzerService service = new DefaultVPMAnalyzerService();
        VPMGraph graph = service.initVPMGraph(vpm);
        return graph;
    }

    public static VPMAnalyzerResult analyzeExtendedSharedAccess(VPMGraph graph) throws VPMAnalyzerException {
        JaMoPPProgramDependencyVPMAnalyzer analyzer = TestUtil.configureRobillardAnalyzer(true, true);
        VPMAnalyzerResult result = analyzer.analyze(graph);
        return result;
    }

    public static void assertDependencyCount(VPMAnalyzerResult result, int count) {
        Assert.assertThat((String)"Wrong number of relationships", (Object)result.getEdgeDescriptors().size(), (Matcher)CoreMatchers.is((Object)count));
    }

    public static void assertDependency(VPMAnalyzerResult result, DependencyType type, Integer count) {
        HashMap dependencies = Maps.newHashMap();
        dependencies.put(type, count);
        TestUtil.assertDependencies(result, dependencies);
    }

    public static void assertDependencies(VPMAnalyzerResult result, Map<DependencyType, Integer> dependencies) {
        TestUtil.assertEdgeInfos(result, "dependency.type", dependencies);
    }

    public static void assertEdgeInfos(VPMAnalyzerResult result, String infoKey, Map<?, Integer> infoValues) {
        HashMultiset detectedInfoValues = HashMultiset.create();
        for (VPMEdgeDescriptor edge : result.getEdgeDescriptors()) {
            detectedInfoValues.add(edge.getRelationShipInfos().get(infoKey));
        }
        for (Object detectedInfo : detectedInfoValues.elementSet()) {
            if (infoValues.containsKey(detectedInfo)) continue;
            Assert.fail((String)("Unexpected value: " + detectedInfo));
        }
        for (Object expectedValue : infoValues.keySet()) {
            int is = detectedInfoValues.count(expectedValue);
            int expected = infoValues.get(expectedValue);
            Assert.assertThat((String)("Wrong count for " + expectedValue), (Object)is, (Matcher)CoreMatchers.is((Object)expected));
        }
    }

    public static void assertNodeCount(VPMGraph graph, int nodeCount) {
        Assert.assertThat((String)"Wrong number of graph nodes", (Object)graph.getNodeSet().size(), (Matcher)CoreMatchers.is((Object)nodeCount));
    }

    public static JaMoPPProgramDependencyVPMAnalyzer configureRobillardAnalyzer(boolean extendedMode, boolean sharedAccess) {
        JaMoPPProgramDependencyVPMAnalyzer analyzer = new JaMoPPProgramDependencyVPMAnalyzer();
        VPMAnalyzerConfigurationSet configurations = analyzer.getConfigurations();
        String groupId = "Program Dependencies";
        String configId = "org.splevo.jamopp.vpm.analyzer.programdependencyREFERENCE_SELECTOR";
        ChoiceConfiguration configuration = (ChoiceConfiguration)configurations.getConfiguration(groupId, configId);
        if (extendedMode && sharedAccess) {
            configuration.setCurrentValue("Robillard Extended (SharedAccess)");
        } else if (extendedMode) {
            configuration.setCurrentValue("Robillard Extended");
        } else {
            configuration.setCurrentValue("Robillard");
        }
        return analyzer;
    }
}

