/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.analyzer.programdependency.tests;

import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.jamopp.vpm.analyzer.programdependency.JaMoPPProgramDependencyVPMAnalyzer;
import org.splevo.jamopp.vpm.analyzer.programdependency.tests.TestUtil;
import org.splevo.tests.SPLevoTestUtil;
import org.splevo.vpm.analyzer.VPMAnalyzerResult;
import org.splevo.vpm.analyzer.graph.VPMGraph;

public class JaMoPPProgramDependencyAnalyzerTest {
    private final JaMoPPProgramDependencyVPMAnalyzer analyzer = TestUtil.configureRobillardAnalyzer(true, false);

    @Test
    public void testAnalyzeGCD() throws Exception {
        VPMGraph graph = SPLevoTestUtil.loadGCDVPMGraph();
        VPMAnalyzerResult result = this.analyzer.analyze(graph);
        Assert.assertThat((String)"Wrong edge descriptor count", (Object)result.getEdgeDescriptors().size(), (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testGetConfigurations() {
        Assert.assertNotNull((String)"Null for configurations is not allowed", (Object)this.analyzer.getConfigurations());
    }

    @Test
    public void testGetName() {
        Assert.assertNotNull((String)"Null name is not allowed", (Object)this.analyzer.getName());
        Assert.assertTrue((String)"Empty name not allowed", (this.analyzer.getName().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetRelationshipLabel() {
        Assert.assertNotNull((String)"Null label is not allowed", (Object)this.analyzer.getRelationshipLabel());
        Assert.assertTrue((String)"Empty label not allowed", (this.analyzer.getRelationshipLabel().length() > 0 ? 1 : 0) != 0);
    }

    @BeforeClass
    public static void setUp() {
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
    }
}

