/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.analyzer.programdependency.references;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ComposedSwitch;
import org.eclipse.emf.ecore.util.Switch;
import org.emftext.language.java.commons.Commentable;
import org.emftext.language.java.containers.CompilationUnit;
import org.emftext.language.java.expressions.AssignmentExpression;
import org.emftext.language.java.expressions.Expression;
import org.emftext.language.java.expressions.util.ExpressionsSwitch;
import org.emftext.language.java.imports.ClassifierImport;
import org.emftext.language.java.imports.Import;
import org.emftext.language.java.imports.util.ImportsSwitch;
import org.emftext.language.java.instantiations.NewConstructorCall;
import org.emftext.language.java.instantiations.util.InstantiationsSwitch;
import org.emftext.language.java.members.ClassMethod;
import org.emftext.language.java.members.Constructor;
import org.emftext.language.java.members.Method;
import org.emftext.language.java.members.util.MembersSwitch;
import org.emftext.language.java.references.IdentifierReference;
import org.emftext.language.java.references.MethodCall;
import org.emftext.language.java.references.util.ReferencesSwitch;
import org.emftext.language.java.statements.ExpressionStatement;
import org.emftext.language.java.statements.LocalVariableStatement;
import org.emftext.language.java.statements.Return;
import org.emftext.language.java.statements.Statement;
import org.emftext.language.java.statements.util.StatementsSwitch;
import org.emftext.language.java.types.Type;
import org.emftext.language.java.types.TypeReference;
import org.emftext.language.java.types.util.TypesSwitch;
import org.emftext.language.java.variables.LocalVariable;
import org.splevo.vpm.analyzer.VPMAnalyzerUtil;

public class DefaultReferenceSelectorSwitch
extends ComposedSwitch<List<Commentable>> {
    private Logger logger = Logger.getLogger(DefaultReferenceSelectorSwitch.class);

    public DefaultReferenceSelectorSwitch() {
        this.addSwitch((Switch)new StatementsReferencedElementsSwitch(this));
        this.addSwitch((Switch)new ExpressionsReferencedElementsSwitch(this));
        this.addSwitch((Switch)new MembersReferencedElementsSwitch(this));
        this.addSwitch((Switch)new ImportReferencedElementsSwitch());
        this.addSwitch((Switch)new ReferencesReferencedElementsSwitch(this));
        this.addSwitch((Switch)new InstantiationsReferencedElementsSwitch(this));
        this.addSwitch((Switch)new TypesReferencedElementsSwitch());
    }

    public List<Commentable> doSwitch(EObject eObject) {
        List elements = null;
        if (!VPMAnalyzerUtil.isNullOrProxy((EObject)eObject)) {
            elements = (List)super.doSwitch(eObject);
        }
        if (elements == null) {
            elements = Lists.newArrayList();
        }
        return elements;
    }

    private class ExpressionsReferencedElementsSwitch
    extends ExpressionsSwitch<List<Commentable>> {
        private DefaultReferenceSelectorSwitch parentSwitch;

        public ExpressionsReferencedElementsSwitch(DefaultReferenceSelectorSwitch parentSwitch) {
            this.parentSwitch = parentSwitch;
        }

        public List<Commentable> caseAssignmentExpression(AssignmentExpression exp) {
            ArrayList refElements = Lists.newArrayList();
            refElements.addAll(this.parentSwitch.doSwitch((EObject)exp.getChild()));
            refElements.addAll(this.parentSwitch.doSwitch((EObject)exp.getValue()));
            return refElements;
        }
    }

    private class ImportReferencedElementsSwitch
    extends ImportsSwitch<List<Commentable>> {
        private ImportReferencedElementsSwitch() {
        }

        public List<Commentable> caseImport(Import object) {
            return Lists.newArrayList((Object[])new Commentable[]{object});
        }
    }

    private class InstantiationsReferencedElementsSwitch
    extends InstantiationsSwitch<List<Commentable>> {
        private DefaultReferenceSelectorSwitch parentSwitch;

        public InstantiationsReferencedElementsSwitch(DefaultReferenceSelectorSwitch parentSwitch) {
            this.parentSwitch = parentSwitch;
        }

        public List<Commentable> caseNewConstructorCall(NewConstructorCall call) {
            ArrayList refElements = Lists.newArrayList();
            for (Expression expression : call.getArguments()) {
                refElements.addAll(this.parentSwitch.doSwitch((EObject)expression));
            }
            refElements.addAll(this.parentSwitch.doSwitch((EObject)call.getTypeReference()));
            return refElements;
        }
    }

    private class MembersReferencedElementsSwitch
    extends MembersSwitch<List<Commentable>> {
        private DefaultReferenceSelectorSwitch parentSwitch;

        public MembersReferencedElementsSwitch(DefaultReferenceSelectorSwitch parentSwitch) {
            this.parentSwitch = parentSwitch;
        }

        public List<Commentable> caseClassMethod(ClassMethod method) {
            ArrayList refElements = Lists.newArrayList((Object[])new Commentable[]{method});
            for (Statement statement : method.getStatements()) {
                refElements.addAll(this.parentSwitch.doSwitch((EObject)statement));
            }
            return refElements;
        }

        public List<Commentable> caseConstructor(Constructor constructor) {
            ArrayList refElements = Lists.newArrayList((Object[])new Commentable[]{constructor});
            for (Statement statement : constructor.getStatements()) {
                refElements.addAll(this.parentSwitch.doSwitch((EObject)statement));
            }
            return refElements;
        }

        public List<Commentable> caseMethod(Method object) {
            return Lists.newArrayList((Object[])new Commentable[]{object});
        }
    }

    private class ReferencesReferencedElementsSwitch
    extends ReferencesSwitch<List<Commentable>> {
        private DefaultReferenceSelectorSwitch parentSwitch;

        public ReferencesReferencedElementsSwitch(DefaultReferenceSelectorSwitch parentSwitch) {
            this.parentSwitch = parentSwitch;
        }

        public List<Commentable> caseMethodCall(MethodCall methodCall) {
            ArrayList refElements = Lists.newArrayList();
            for (Expression expression : methodCall.getArguments()) {
                refElements.addAll(this.parentSwitch.doSwitch((EObject)expression));
            }
            refElements.addAll(this.parentSwitch.doSwitch((EObject)methodCall.getTarget()));
            return refElements;
        }

        public List<Commentable> caseIdentifierReference(IdentifierReference reference) {
            ArrayList refElements = Lists.newArrayList((Object[])new Commentable[]{reference.getTarget()});
            if (reference.getNext() != null) {
                refElements.addAll(this.parentSwitch.doSwitch((EObject)reference.getNext()));
            }
            return refElements;
        }
    }

    private class StatementsReferencedElementsSwitch
    extends StatementsSwitch<List<Commentable>> {
        private DefaultReferenceSelectorSwitch parentSwitch;

        public StatementsReferencedElementsSwitch(DefaultReferenceSelectorSwitch parentSwitch) {
            this.parentSwitch = parentSwitch;
        }

        public List<Commentable> caseReturn(Return returnStmt) {
            ArrayList refElements = Lists.newArrayList((Object[])new Commentable[]{returnStmt});
            refElements.addAll(this.parentSwitch.doSwitch((EObject)returnStmt.getReturnValue()));
            return refElements;
        }

        public List<Commentable> caseLocalVariableStatement(LocalVariableStatement lvs) {
            ArrayList refElements = Lists.newArrayList();
            LocalVariable variable = lvs.getVariable();
            if (variable != null) {
                refElements.add(lvs.getVariable());
                refElements.addAll(this.parentSwitch.doSwitch((EObject)variable.getTypeReference()));
                refElements.addAll(this.parentSwitch.doSwitch((EObject)variable.getInitialValue()));
                refElements.addAll(variable.getAdditionalLocalVariables());
            } else {
                DefaultReferenceSelectorSwitch.this.logger.warn((Object)("VariableStatement without variable: " + lvs));
            }
            return refElements;
        }

        public List<Commentable> caseExpressionStatement(ExpressionStatement stmt) {
            return this.parentSwitch.doSwitch((EObject)stmt.getExpression());
        }
    }

    private class TypesReferencedElementsSwitch
    extends TypesSwitch<List<Commentable>> {
        private TypesReferencedElementsSwitch() {
        }

        public List<Commentable> caseTypeReference(TypeReference typeReference) {
            Type type = typeReference.getTarget();
            ArrayList refElements = Lists.newArrayList((Object[])new Commentable[]{type});
            CompilationUnit cu = typeReference.getContainingCompilationUnit();
            EList imports = cu.getChildrenByType(ClassifierImport.class);
            for (ClassifierImport classifierImport : imports) {
                if (!classifierImport.getClassifier().equals(type)) continue;
                refElements.add(classifierImport);
            }
            return refElements;
        }
    }
}

