/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.analyzer.programdependency;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.splevo.jamopp.vpm.analyzer.programdependency.references.DependencyType;
import org.splevo.jamopp.vpm.analyzer.programdependency.references.ReferenceSelectorRegistry;
import org.splevo.vpm.analyzer.config.BooleanConfiguration;
import org.splevo.vpm.analyzer.config.ChoiceConfiguration;

public final class ConfigurationBuilder {
    private static final String CONFIG_ID_BASE = "org.splevo.jamopp.vpm.analyzer.programdependency";
    public static final String CONFIG_GROUP_DEPENDENCIES = "Program Dependencies";
    public static final String CONFIG_ID_FILTER_EXTERNAL_DEPENDENCIES = "org.splevo.jamopp.vpm.analyzer.programdependencyFILTER_EXTERNAL_DEPENDENCIES";
    public static final String LABEL_FILTER_EXTERNAL_DEPENDENCIES = "Filter external dependencies";
    public static final String EXPL_FILTER_EXTERNAL_DEPENDENCIES = "Filter shared dependencies to software elements (e.g. classes or methods) located in external libraries (jar files).";
    public static final boolean DEFAULT_FILTER_EXTERNAL_DEPENDENCIES = true;
    public static final String CONFIG_ID_REFERENCE_SELECTOR = "org.splevo.jamopp.vpm.analyzer.programdependencyREFERENCE_SELECTOR";
    public static final String LABEL_REFERENCE_SELECTOR = "Reference Selector";
    public static final String EXPL_REFERENCE_SELECTOR = "Choose the selector to decide about which references between software elments should be considered.";
    public static final String DEFAULT_REFERENCE_SELECTOR = "Robillard Extended";
    public static final String CONFIG_ID_DESIRED_DEPENDENCY_TYPE = "org.splevo.jamopp.vpm.analyzer.programdependencyDESIRED_DEPENDENCY_TYPE";
    public static final String LABEL_DESIRED_DEPENDENCY_TYPE = "Desired Dependency Type";
    public static final String EXPL_DESIRED_DEPENDENCY_TYPE = "Choose the desired dependency type to limit the analysis to.";
    public static final String DEFAULT_DESIRED_DEPENDENCY_TYPE = "ALL";

    private ConfigurationBuilder() {
    }

    public static BooleanConfiguration createFilterExternalsConfig() {
        return new BooleanConfiguration(CONFIG_ID_FILTER_EXTERNAL_DEPENDENCIES, LABEL_FILTER_EXTERNAL_DEPENDENCIES, EXPL_FILTER_EXTERNAL_DEPENDENCIES, Boolean.valueOf(true));
    }

    public static ChoiceConfiguration createReferenceSelectorConfig() {
        return new ChoiceConfiguration(CONFIG_ID_REFERENCE_SELECTOR, LABEL_REFERENCE_SELECTOR, EXPL_REFERENCE_SELECTOR, DEFAULT_REFERENCE_SELECTOR, ReferenceSelectorRegistry.getAvailableSelectorIds());
    }

    public static ChoiceConfiguration createDesiredDependencyTypeConfig() {
        ArrayList values = Lists.newArrayList((Object[])new String[]{DEFAULT_DESIRED_DEPENDENCY_TYPE});
        DependencyType[] dependencyTypeArray = DependencyType.values();
        int n = dependencyTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DependencyType type = dependencyTypeArray[n2];
            switch (type) {
                case SHARED: 
                case IGNORE: {
                    break;
                }
                default: {
                    values.add(type.toString());
                }
            }
            ++n2;
        }
        Collections.sort(values);
        return new ChoiceConfiguration(CONFIG_ID_DESIRED_DEPENDENCY_TYPE, LABEL_DESIRED_DEPENDENCY_TYPE, EXPL_DESIRED_DEPENDENCY_TYPE, DEFAULT_DESIRED_DEPENDENCY_TYPE, (List)values);
    }
}

