/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.analyzer.programdependency.references;

import org.apache.log4j.Logger;
import org.emftext.language.java.commons.Commentable;
import org.splevo.jamopp.util.JaMoPPElementUtil;
import org.splevo.jamopp.vpm.analyzer.programdependency.references.DependencyType;
import org.splevo.jamopp.vpm.analyzer.programdependency.references.ReferenceType;

public class Reference {
    private static Logger logger = Logger.getLogger(Reference.class);
    private Commentable source = null;
    private Commentable target = null;
    private ReferenceType type = null;

    public Reference(Commentable self) {
        this(self, self, ReferenceType.SELF);
    }

    public Reference(Commentable source, Commentable target) {
        this(source, target, ReferenceType.DEFAULT);
    }

    public Reference(Commentable source, Commentable target, ReferenceType type) {
        this.source = source;
        this.target = target;
        this.type = type;
    }

    public void setSource(Commentable source) {
        this.source = source;
    }

    public Commentable getSource() {
        return this.source;
    }

    public Commentable getTarget() {
        return this.target;
    }

    public ReferenceType getType() {
        return this.type;
    }

    public DependencyType getDependencyType() {
        String typeID = null;
        typeID = this.type == ReferenceType.SuperType ? String.format("%s%s%s", JaMoPPElementUtil.getTypeLabel((Commentable)this.target), this.type.name(), JaMoPPElementUtil.getTypeLabel((Commentable)this.source)) : String.format("%s%s%s", JaMoPPElementUtil.getTypeLabel((Commentable)this.source), this.type.name(), JaMoPPElementUtil.getTypeLabel((Commentable)this.target));
        try {
            return DependencyType.valueOf(typeID);
        }
        catch (Exception e) {
            logger.error((Object)("Reference with unknown DependencyType: " + typeID));
            return DependencyType.IGNORE;
        }
    }

    public void setType(ReferenceType type) {
        this.type = type;
    }

    public String toString() {
        return String.format("Reference[%s]", new Object[]{this.getDependencyType()});
    }
}

