/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.analyzer.programdependency;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.emftext.language.java.commons.Commentable;
import org.graphstream.graph.Node;
import org.splevo.jamopp.util.JaMoPPElementUtil;
import org.splevo.jamopp.vpm.analyzer.programdependency.ConfigurationBuilder;
import org.splevo.jamopp.vpm.analyzer.programdependency.references.DependencyType;
import org.splevo.jamopp.vpm.analyzer.programdependency.references.Reference;
import org.splevo.jamopp.vpm.analyzer.programdependency.references.ReferenceSelector;
import org.splevo.jamopp.vpm.analyzer.programdependency.references.ReferenceSelectorRegistry;
import org.splevo.jamopp.vpm.software.JaMoPPJavaSoftwareElement;
import org.splevo.vpm.analyzer.AbstractVPMAnalyzer;
import org.splevo.vpm.analyzer.VPMAnalyzer;
import org.splevo.vpm.analyzer.VPMAnalyzerException;
import org.splevo.vpm.analyzer.VPMAnalyzerResult;
import org.splevo.vpm.analyzer.VPMEdgeDescriptor;
import org.splevo.vpm.analyzer.config.AbstractVPMAnalyzerConfiguration;
import org.splevo.vpm.analyzer.config.BooleanConfiguration;
import org.splevo.vpm.analyzer.config.ChoiceConfiguration;
import org.splevo.vpm.analyzer.config.VPMAnalyzerConfigurationSet;
import org.splevo.vpm.analyzer.graph.VPMGraph;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;

public class JaMoPPProgramDependencyVPMAnalyzer
extends AbstractVPMAnalyzer {
    private static Logger logger = Logger.getLogger(JaMoPPProgramDependencyVPMAnalyzer.class);
    public static final String RELATIONSHIP_LABEL_PROGRAM_STRUCTURE = "ProgramDependency";
    public static final String EDGE_INFO_DEPENDENCY_TYPE = "dependency.type";
    private BooleanConfiguration filterExternalsConfig = ConfigurationBuilder.createFilterExternalsConfig();
    private ChoiceConfiguration referenceSelectorConfig = ConfigurationBuilder.createReferenceSelectorConfig();
    private ChoiceConfiguration desiredDependencyTypeConfig = ConfigurationBuilder.createDesiredDependencyTypeConfig();

    public VPMAnalyzerResult analyze(VPMGraph vpmGraph) throws VPMAnalyzerException {
        String selectorId = (String)this.referenceSelectorConfig.getCurrentValue();
        ReferenceSelector referenceSelector = ReferenceSelectorRegistry.getReferenceSelector(selectorId);
        VPReferenceIndex index = this.indexVPReferences(vpmGraph, referenceSelector);
        List<VPMEdgeDescriptor> descriptors = this.identifyDependencies(referenceSelector, index);
        VPMAnalyzerResult result = new VPMAnalyzerResult((VPMAnalyzer)this);
        result.getEdgeDescriptors().addAll(descriptors);
        logger.info((Object)("ReferenceSelector Mode: " + selectorId));
        return result;
    }

    private VPReferenceIndex indexVPReferences(VPMGraph vpmGraph, ReferenceSelector referenceSelector) {
        VPReferenceIndex index = new VPReferenceIndex();
        this.indexGraphNodes(vpmGraph, index);
        this.indexReferencedElements(referenceSelector, index);
        return index;
    }

    private List<VPMEdgeDescriptor> identifyDependencies(ReferenceSelector referenceSelector, VPReferenceIndex index) {
        ArrayList edges = Lists.newArrayList();
        ArrayList<String> edgeRegistry = new ArrayList<String>();
        LinkedHashMultiset statistics = LinkedHashMultiset.create();
        for (Commentable element : index.referencedElementsIndex.keySet()) {
            List<VPMEdgeDescriptor> vpEdges = this.identifyRelatedVPsForReferencedElement(edgeRegistry, element, referenceSelector, index, (Multiset<DependencyType>)statistics);
            edges.addAll(vpEdges);
        }
        this.printStatistics((Multiset<DependencyType>)statistics);
        return edges;
    }

    private void printStatistics(Multiset<DependencyType> statistics) {
        StringBuilder builder = new StringBuilder();
        builder.append("Statistics:");
        for (DependencyType type : statistics.elementSet()) {
            builder.append("\n");
            builder.append((Object)((Object)type) + "\t" + statistics.count((Object)type));
        }
        logger.debug((Object)builder.toString());
    }

    private List<VPMEdgeDescriptor> identifyRelatedVPsForReferencedElement(List<String> edgeRegistry, Commentable referencedElement, ReferenceSelector referenceSelector, VPReferenceIndex index, Multiset<DependencyType> statistics) {
        ArrayList referencedElementEdges = Lists.newArrayList();
        Set referencingVPs = index.referencedElementsIndex.get((Object)referencedElement);
        if (referencingVPs.size() > 1) {
            VariationPoint[] vpList = referencingVPs.toArray(new VariationPoint[referencingVPs.size()]);
            int i = 0;
            while (i < vpList.length) {
                int j = i + 1;
                while (j < vpList.length) {
                    VariationPoint vp1 = vpList[i];
                    VariationPoint vp2 = vpList[j];
                    if (vp1 != null && vp2 != null && vp2 != vp1) {
                        DependencyType dependencyType = DependencyType.IGNORE;
                        Reference referenceVP1 = null;
                        Reference referenceVP2 = null;
                        for (Reference refVP1 : index.getIndexedReferences(vp1, referencedElement)) {
                            for (Reference refVP2 : index.getIndexedReferences(vp2, referencedElement)) {
                                DependencyType type = referenceSelector.getDependencyType(refVP1, refVP2, referencedElement);
                                if (!this.isDesiredType(type)) continue;
                                statistics.add((Object)type);
                                dependencyType = type;
                                referenceVP1 = refVP1;
                                referenceVP2 = refVP2;
                            }
                        }
                        if (dependencyType != DependencyType.IGNORE) {
                            Node nodeVP1 = (Node)index.vp2GraphNodeIndex.get(vp1);
                            Node nodeVP2 = (Node)index.vp2GraphNodeIndex.get(vp2);
                            String vp1ID = nodeVP1.getId();
                            String vp2ID = nodeVP2.getId();
                            String sourceLabel = JaMoPPElementUtil.getLabel((Commentable)referenceVP1.getSource());
                            String targetLabel = JaMoPPElementUtil.getLabel((Commentable)referenceVP2.getSource());
                            String subLabel = this.getSubLabel(referencedElement, referenceVP1.getSource(), referenceVP2.getSource(), sourceLabel, targetLabel);
                            VPMEdgeDescriptor edge = this.buildEdgeDescriptor(nodeVP1, nodeVP2, subLabel, edgeRegistry);
                            if (edge != null) {
                                edge.getRelationShipInfos().put(EDGE_INFO_DEPENDENCY_TYPE, dependencyType);
                                this.logAnalysisInfo(vp1ID, vp2ID, sourceLabel, targetLabel, subLabel);
                                referencedElementEdges.add(edge);
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return referencedElementEdges;
    }

    private boolean isDesiredType(DependencyType type) {
        if (type == DependencyType.IGNORE) {
            return false;
        }
        String desiredType = (String)this.desiredDependencyTypeConfig.getCurrentValue();
        if (desiredType == this.desiredDependencyTypeConfig.getDefaultValue()) {
            return true;
        }
        return type == DependencyType.valueOf(desiredType);
    }

    private String getSubLabel(Commentable referencedElement, Commentable refElementVP1, Commentable refElementVP2, String sourceLabel, String targetLabel) {
        String subLabel = null;
        String referencedElementLabel = JaMoPPElementUtil.getLabel((Commentable)referencedElement);
        subLabel = refElementVP1 == referencedElement ? String.format("%s references %s", targetLabel, referencedElementLabel) : (refElementVP2 == referencedElement ? String.format("%s references %s", sourceLabel, referencedElementLabel) : String.format("%s and %s share references to %s", sourceLabel, targetLabel, referencedElementLabel));
        return subLabel;
    }

    private void indexReferencedElements(ReferenceSelector referenceSelector, VPReferenceIndex index) {
        Set variationPoints = index.vp2GraphNodeIndex.keySet();
        for (VariationPoint vp : variationPoints) {
            List<Commentable> jamoppElements = this.getJamoppElements(vp);
            for (Commentable jamoppElement : jamoppElements) {
                this.indexReferencedElements(vp, jamoppElement, referenceSelector, index);
            }
        }
    }

    private void indexReferencedElements(VariationPoint vp, Commentable referringElement, ReferenceSelector referenceSelector, VPReferenceIndex index) {
        List<Reference> referencedElements = referenceSelector.getReferencedElements(referringElement);
        for (Reference reference : referencedElements) {
            Resource resource;
            if (((Boolean)this.filterExternalsConfig.getCurrentValue()).booleanValue() && (reference.getTarget() == null || (resource = reference.getTarget().eResource()) != null && "pathmap".equals(resource.getURI().scheme()))) continue;
            index.referencedElementsIndex.get((Object)reference.getTarget()).add(vp);
            index.getIndexedReferences(vp, reference.getTarget()).add(reference);
        }
    }

    private List<Commentable> getJamoppElements(VariationPoint vp) {
        List<SoftwareElement> softwareElements = this.getVariantsSoftwareElements(vp);
        ArrayList jamoppElements = Lists.newArrayList();
        for (SoftwareElement softwareElement : softwareElements) {
            if (!(softwareElement instanceof JaMoPPJavaSoftwareElement)) continue;
            jamoppElements.add(((JaMoPPJavaSoftwareElement)softwareElement).getJamoppElement());
        }
        return jamoppElements;
    }

    private List<SoftwareElement> getVariantsSoftwareElements(VariationPoint vp) {
        ArrayList<SoftwareElement> softwareElements = new ArrayList<SoftwareElement>();
        for (Variant v : vp.getVariants()) {
            for (SoftwareElement softwareElement : v.getImplementingElements()) {
                softwareElements.add(softwareElement);
            }
        }
        return softwareElements;
    }

    private void indexGraphNodes(VPMGraph vpmGraph, VPReferenceIndex index) {
        for (Node node : vpmGraph.getNodeSet()) {
            VariationPoint vp = (VariationPoint)node.getAttribute("vp.vp", VariationPoint.class);
            index.vp2GraphNodeIndex.put(vp, node);
        }
    }

    public VPMAnalyzerConfigurationSet getConfigurations() {
        VPMAnalyzerConfigurationSet configurations = new VPMAnalyzerConfigurationSet();
        configurations.addConfigurations("Program Dependencies", new AbstractVPMAnalyzerConfiguration[]{this.filterExternalsConfig, this.referenceSelectorConfig, this.desiredDependencyTypeConfig});
        return configurations;
    }

    public String getName() {
        return "JaMoPP Program Dependency Analyzer";
    }

    public String getRelationshipLabel() {
        return RELATIONSHIP_LABEL_PROGRAM_STRUCTURE;
    }

    private class VPReferenceIndex {
        private final Map<VariationPoint, Node> vp2GraphNodeIndex = new LinkedHashMap<VariationPoint, Node>();
        private final LinkedHashMultimap<Commentable, VariationPoint> referencedElementsIndex = LinkedHashMultimap.create();
        private final Table<VariationPoint, Commentable, List<Reference>> referringElementIndex = HashBasedTable.create();

        private VPReferenceIndex() {
        }

        public List<Reference> getIndexedReferences(VariationPoint vp, Commentable target) {
            List references = (List)this.referringElementIndex.get((Object)vp, (Object)target);
            if (references == null) {
                this.referringElementIndex.put((Object)vp, (Object)target, new ArrayList());
            }
            return (List)this.referringElementIndex.get((Object)vp, (Object)target);
        }
    }
}

