/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.analyzer.programdependency.references;

import org.splevo.jamopp.vpm.analyzer.programdependency.references.ReferenceSelector;
import org.splevo.jamopp.vpm.analyzer.programdependency.references.RobillardReferenceSelector;

public class ReferenceSelectorRegistry {
    public static final String ROBILLARD_SELECTOR = "Robillard";
    public static final String ROBILLARD_EXTENDED_SELECTOR = "Robillard Extended";
    public static final String ROBILLARD_EXTENDED_SHARED_ACCESS_SELECTOR = "Robillard Extended (SharedAccess)";

    public static ReferenceSelector getReferenceSelector(String id) {
        if (ROBILLARD_SELECTOR.equals(id)) {
            return new RobillardReferenceSelector(false, false);
        }
        if (ROBILLARD_EXTENDED_SELECTOR.equals(id)) {
            return new RobillardReferenceSelector(true, false);
        }
        if (ROBILLARD_EXTENDED_SHARED_ACCESS_SELECTOR.equals(id)) {
            return new RobillardReferenceSelector(true, true);
        }
        throw new IllegalArgumentException("Non existing reference selector requested: " + id);
    }

    public static String[] getAvailableSelectorIds() {
        return new String[]{ROBILLARD_EXTENDED_SELECTOR, ROBILLARD_SELECTOR};
    }
}

