/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.analyzer.semantic;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.emftext.language.java.commons.Commentable;
import org.emftext.language.java.statements.Block;
import org.emftext.language.java.statements.StatementsFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.extraction.SoftwareModelExtractionException;
import org.splevo.jamopp.extraction.JaMoPPSoftwareModelExtractor;
import org.splevo.jamopp.vpm.analyzer.semantic.JaMoPPSemanticContentProvider;
import org.splevo.jamopp.vpm.software.JaMoPPSoftwareElement;
import org.splevo.jamopp.vpm.software.softwareFactory;
import org.splevo.vpm.analyzer.semantic.extensionpoint.SemanticContent;
import org.splevo.vpm.analyzer.semantic.extensionpoint.UnsupportedSoftwareElementException;
import org.splevo.vpm.software.SoftwareElement;

public class JaMoPPSemanticContentProviderTest {
    private JaMoPPSemanticContentProvider provider;

    @BeforeClass
    public static void init() {
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
    }

    @Before
    public void setUp() {
        this.provider = new JaMoPPSemanticContentProvider();
    }

    @Test
    public void testGetRelevantContent() throws UnsupportedSoftwareElementException {
        JaMoPPSoftwareElement element = softwareFactory.eINSTANCE.createJaMoPPSoftwareElement();
        Block myBlock = StatementsFactory.eINSTANCE.createBlock();
        myBlock.setName("Block");
        element.setJamoppElement((Commentable)myBlock);
        SemanticContent relevantContent = this.provider.getRelevantContent((SoftwareElement)element, false);
        Collection code = relevantContent.getCode();
        Assert.assertThat((Object)code.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testProvideCompilationUnitContent() throws Exception {
        SoftwareElement element = this.constructSoftwareElement("CompilationUnit");
        Object[] expected = new String[]{"MyClass", "MyClass.java", "doSth", "param1"};
        Collection actual = this.provider.getRelevantContent(element, false).getCode();
        Assert.assertThat((Object)actual, (Matcher)CoreMatchers.hasItems((Object[])expected));
        Assert.assertThat((Object)actual.size(), (Matcher)CoreMatchers.equalTo((Object)expected.length));
    }

    @Test
    public void testProvideCompilationUnitContentExtended() throws UnsupportedSoftwareElementException, SoftwareModelExtractionException, IOException {
        SoftwareElement element = this.constructSoftwareElement("ExtendedDetection");
        Object[] expected = new String[]{"OtherClass.java", "OtherClass", "aMethod", "aNumber", "Arrays", "asList", "System", "out", "println", "qq123"};
        Collection actual = this.provider.getRelevantContent(element, false).getCode();
        Assert.assertThat((Object)actual, (Matcher)CoreMatchers.hasItems((Object[])expected));
        Assert.assertThat((Object)actual.size(), (Matcher)CoreMatchers.equalTo((Object)expected.length));
    }

    private SoftwareElement constructSoftwareElement(String name) throws IOException, SoftwareModelExtractionException {
        String relativePath = "testcode/" + name + "/";
        String pathA = new File(relativePath).getCanonicalPath();
        JaMoPPSoftwareModelExtractor extractor = new JaMoPPSoftwareModelExtractor();
        ResourceSet setA = extractor.extractSoftwareModel((List)Lists.newArrayList((Object[])new String[]{pathA}), (IProgressMonitor)new NullProgressMonitor());
        Resource resource = (Resource)setA.getResources().get(0);
        EObject eObject = (EObject)resource.getContents().get(0);
        JaMoPPSoftwareElement element = softwareFactory.eINSTANCE.createJaMoPPSoftwareElement();
        element.setJamoppElement((Commentable)eObject);
        return element;
    }
}

