/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.analyzer.semantic;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.emftext.language.java.commons.Commentable;
import org.splevo.jamopp.vpm.analyzer.semantic.JaMoPPSemanticContentProviderSwitch;
import org.splevo.jamopp.vpm.software.JaMoPPJavaSoftwareElement;
import org.splevo.vpm.analyzer.semantic.extensionpoint.SemanticContent;
import org.splevo.vpm.analyzer.semantic.extensionpoint.SemanticContentProvider;
import org.splevo.vpm.analyzer.semantic.extensionpoint.UnsupportedSoftwareElementException;
import org.splevo.vpm.software.SoftwareElement;

public class JaMoPPSemanticContentProvider
implements SemanticContentProvider {
    private static final JaMoPPSemanticContentProviderSwitch CONTENT_SWITCH = new JaMoPPSemanticContentProviderSwitch(false);

    public SemanticContent getRelevantContent(SoftwareElement element, boolean matchComments) throws UnsupportedSoftwareElementException {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        if (!(element instanceof JaMoPPJavaSoftwareElement)) {
            throw new UnsupportedSoftwareElementException(element);
        }
        return this.getContentFromChildren((JaMoPPJavaSoftwareElement)element, matchComments);
    }

    private SemanticContent getContentFromChildren(JaMoPPJavaSoftwareElement softwareElement, boolean matchComments) {
        SemanticContent content = new SemanticContent();
        Commentable element = softwareElement.getJamoppElement();
        if (element == null) {
            return content;
        }
        ArrayList elementsToCheck = Lists.newArrayList((Iterator)element.eAllContents());
        elementsToCheck.add(element);
        for (EObject child : elementsToCheck) {
            if (!(child instanceof Commentable)) continue;
            Commentable commentableChild = (Commentable)child;
            Iterable<String> texts = this.getRelevantTextFromElement((EObject)commentableChild);
            for (String text : texts) {
                content.addCode(text);
            }
            if (!matchComments) continue;
            StringBuilder builder = new StringBuilder();
            for (String comment : commentableChild.getComments()) {
                builder.append(comment);
            }
            content.addComment(builder.toString());
        }
        return content;
    }

    private Iterable<String> getRelevantTextFromElement(EObject eObject) {
        return CONTENT_SWITCH.doSwitch(eObject);
    }
}

