/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.analyzer.semantic;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ComposedSwitch;
import org.eclipse.emf.ecore.util.Switch;
import org.emftext.language.java.commons.Commentable;
import org.emftext.language.java.commons.CommonsPackage;
import org.emftext.language.java.commons.NamedElement;
import org.emftext.language.java.commons.util.CommonsSwitch;
import org.emftext.language.java.imports.ClassifierImport;
import org.emftext.language.java.imports.StaticMemberImport;
import org.emftext.language.java.imports.util.ImportsSwitch;
import org.emftext.language.java.references.ElementReference;
import org.emftext.language.java.references.StringReference;
import org.emftext.language.java.references.util.ReferencesSwitch;
import org.emftext.language.java.statements.Block;
import org.emftext.language.java.statements.Jump;
import org.emftext.language.java.statements.util.StatementsSwitch;

public class JaMoPPSemanticContentProviderSwitch
extends ComposedSwitch<Iterable<String>> {
    public JaMoPPSemanticContentProviderSwitch(boolean onlyUseName) {
        this.addSwitch((Switch)new CommonsContentProviderSwitch());
        if (!onlyUseName) {
            this.addSwitch((Switch)new ImportContentProviderSwitch());
            this.addSwitch((Switch)new ReferencesContentProviderSwitch());
            this.addSwitch((Switch)new StatementContentProviderSwitch());
        }
    }

    public Iterable<String> doSwitch(EObject eObject) {
        if (eObject == null) {
            return Lists.newArrayList();
        }
        Iterable result = (Iterable)super.doSwitch(eObject);
        if (result == null) {
            return Lists.newArrayList();
        }
        return Iterables.filter((Iterable)result, (Predicate)Predicates.notNull());
    }

    protected Iterable<String> doSwitch(EClass theEClass, EObject theEObject) {
        LinkedList typesToCheck = Lists.newLinkedList((Iterable)theEClass.getEAllSuperTypes());
        typesToCheck.add(0, theEClass);
        typesToCheck.remove(CommonsPackage.eINSTANCE.getCommentable());
        for (EClass eclass : typesToCheck) {
            Iterable result;
            Switch delegate = this.findDelegate(eclass.getEPackage());
            if (delegate == null || (result = (Iterable)this.delegatedDoSwitch(delegate, eclass, theEObject)) == null) continue;
            return result;
        }
        return (Iterable)this.defaultCase(theEObject);
    }

    private Iterable<String> doInternalSwitch(EClass clazz, EObject eObject) {
        return this.doSwitch(clazz, eObject);
    }

    private Iterable<String> doInternalSwitch(Commentable ... elements) {
        return this.doInternalSwitch(Lists.newArrayList((Object[])elements));
    }

    private Iterable<String> doInternalSwitch(Iterable<? extends Commentable> elements) {
        return Iterables.concat((Iterable)Iterables.filter((Iterable)Iterables.transform(elements, (Function)new Function<Commentable, Iterable<String>>(){

            public Iterable<String> apply(Commentable input) {
                return JaMoPPSemanticContentProviderSwitch.this.doSwitch((EObject)input);
            }
        }), (Predicate)Predicates.notNull()));
    }

    private <T> Iterable<T> asIterable(T ... elements) {
        return Lists.newArrayList((Object[])elements);
    }

    private class CommonsContentProviderSwitch
    extends CommonsSwitch<Iterable<String>> {
        private CommonsContentProviderSwitch() {
        }

        public Iterable<String> caseNamedElement(NamedElement object) {
            return JaMoPPSemanticContentProviderSwitch.this.asIterable(new String[]{object.getName()});
        }
    }

    private class ImportContentProviderSwitch
    extends ImportsSwitch<Iterable<String>> {
        private ImportContentProviderSwitch() {
        }

        public Iterable<String> caseClassifierImport(ClassifierImport object) {
            return JaMoPPSemanticContentProviderSwitch.this.doInternalSwitch(new Commentable[]{object.getClassifier()});
        }

        public Iterable<String> caseStaticMemberImport(StaticMemberImport object) {
            return JaMoPPSemanticContentProviderSwitch.this.doInternalSwitch(new Commentable[]{object.getStatic()});
        }
    }

    private class ReferencesContentProviderSwitch
    extends ReferencesSwitch<Iterable<String>> {
        private ReferencesContentProviderSwitch() {
        }

        public Iterable<String> caseStringReference(StringReference object) {
            return JaMoPPSemanticContentProviderSwitch.this.asIterable(new String[]{object.getValue()});
        }

        public Iterable<String> caseElementReference(ElementReference object) {
            return JaMoPPSemanticContentProviderSwitch.this.asIterable(new String[]{object.getTarget().getName()});
        }
    }

    private class StatementContentProviderSwitch
    extends StatementsSwitch<Iterable<String>> {
        private StatementContentProviderSwitch() {
        }

        public Iterable<String> caseJump(Jump object) {
            return JaMoPPSemanticContentProviderSwitch.this.doInternalSwitch(new Commentable[]{object.getTarget()});
        }

        public Iterable<String> caseBlock(Block object) {
            if ("block".equalsIgnoreCase(object.getName())) {
                return Lists.newArrayList();
            }
            return JaMoPPSemanticContentProviderSwitch.this.doInternalSwitch(CommonsPackage.eINSTANCE.getNamedElement(), (EObject)object);
        }
    }
}

