/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.jamopp.diffing.JaMoPPDiffer;
import org.splevo.jamopp.extraction.JaMoPPSoftwareModelExtractor;
import org.splevo.jamopp.vpm.builder.JaMoPPVPMBuilder;
import org.splevo.vpm.variability.VariationPointModel;

public class JaMoPPVPMBuilderTest {
    private Logger logger = Logger.getLogger(JaMoPPVPMBuilderTest.class);

    @BeforeClass
    public static void setUp() {
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
    }

    @Test
    public void test() throws Exception {
        JaMoPPSoftwareModelExtractor extractor = new JaMoPPSoftwareModelExtractor();
        String basePath = "testcode/";
        ArrayList urisA = Lists.newArrayList((Object[])new String[]{new File(String.valueOf(basePath) + "a").getAbsolutePath()});
        ArrayList urisB = Lists.newArrayList((Object[])new String[]{new File(String.valueOf(basePath) + "b").getAbsolutePath()});
        NullProgressMonitor monitor = new NullProgressMonitor();
        ResourceSet setA = extractor.extractSoftwareModel((List)urisA, (IProgressMonitor)monitor, null);
        ResourceSet setB = extractor.extractSoftwareModel((List)urisB, (IProgressMonitor)monitor, null);
        String ignorePackages = this.buildIgnorePackages();
        LinkedHashMap diffOptions = Maps.newLinkedHashMap();
        diffOptions.put("JaMoPP.Java.Packages.to.ignore", ignorePackages);
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(setA, setB, (Map)diffOptions);
        Assert.assertThat((String)"Wrong number of differences", (Object)comparison.getDifferences().size(), (Matcher)CoreMatchers.is((Object)5));
        JaMoPPVPMBuilder builder = new JaMoPPVPMBuilder();
        VariationPointModel vpm = builder.buildVPM(comparison, "leading", "integration");
        Assert.assertThat((String)"Wrong number of vpm groups", (Object)vpm.getVariationPointGroups().size(), (Matcher)CoreMatchers.is((Object)5));
    }

    private String buildIgnorePackages() {
        StringBuilder sb = new StringBuilder();
        sb.append("java.*");
        sb.append(System.getProperty("line.separator"));
        sb.append("org.jscience.*");
        sb.append(System.getProperty("line.separator"));
        sb.append("javolution.*");
        String ignorePackages = sb.toString();
        return ignorePackages;
    }
}

