/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.mergedecider;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.emftext.language.java.statements.LocalVariableStatement;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.jamopp.diffing.JaMoPPDiffer;
import org.splevo.jamopp.extraction.JaMoPPSoftwareModelExtractor;
import org.splevo.jamopp.vpm.builder.JaMoPPVPMBuilder;
import org.splevo.jamopp.vpm.mergedecider.JaMoPPMergeDecider;
import org.splevo.jamopp.vpm.software.JaMoPPJavaSoftwareElement;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;

public class JaMoPPMergeDeciderTest {
    @BeforeClass
    public static void setUp() {
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
    }

    @Test
    public void testDeclaredVariableChanged() throws Exception {
        String basePath = "testcode/DeclaredVariableChanged/";
        VariationPointModel vpm = this.initializeVariationPointModel(basePath);
        Assert.assertThat((String)"Wrong number of vpm groups", (Object)vpm.getVariationPointGroups().size(), (Matcher)CoreMatchers.is((Object)2));
        VariationPoint vp1 = (VariationPoint)((VariationPointGroup)vpm.getVariationPointGroups().get(0)).getVariationPoints().get(0);
        VariationPoint vp2 = (VariationPoint)((VariationPointGroup)vpm.getVariationPointGroups().get(1)).getVariationPoints().get(0);
        JaMoPPMergeDecider decider = new JaMoPPMergeDecider();
        Boolean mergeDecision = decider.canBeMerged(vp1, vp2);
        Assert.assertThat((String)"Wrong merge decision", (Object)mergeDecision, (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
    }

    @Test
    public void testMergedDecisionImports() throws Exception {
        String basePath = "testcode/import/";
        VariationPointModel vpm = this.initializeVariationPointModel(basePath);
        Assert.assertThat((String)"Wrong number of vpm groups", (Object)vpm.getVariationPointGroups().size(), (Matcher)CoreMatchers.is((Object)2));
        VariationPoint vp1 = (VariationPoint)((VariationPointGroup)vpm.getVariationPointGroups().get(0)).getVariationPoints().get(0);
        VariationPoint vp2 = (VariationPoint)((VariationPointGroup)vpm.getVariationPointGroups().get(1)).getVariationPoints().get(0);
        JaMoPPMergeDecider decider = new JaMoPPMergeDecider();
        Boolean mergeDecision = decider.canBeMerged(vp1, vp2);
        Assert.assertThat((String)"Wrong merge decision", (Object)mergeDecision, (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
    }

    @Test
    public void testUnmergeableStatements() throws Exception {
        String basePath = "testcode/unmergeable-statements/";
        VariationPointModel vpm = this.initializeVariationPointModel(basePath);
        Assert.assertThat((String)"Wrong number of vpm groups", (Object)vpm.getVariationPointGroups().size(), (Matcher)CoreMatchers.is((Object)2));
        VariationPoint vp1 = (VariationPoint)((VariationPointGroup)vpm.getVariationPointGroups().get(0)).getVariationPoints().get(0);
        VariationPoint vp2 = (VariationPoint)((VariationPointGroup)vpm.getVariationPointGroups().get(1)).getVariationPoints().get(0);
        Assert.assertThat((String)"Wrong number of variants", (Object)vp1.getVariants().size(), (Matcher)CoreMatchers.is((Object)1));
        JaMoPPJavaSoftwareElement jamoppElement = (JaMoPPJavaSoftwareElement)((Variant)vp1.getVariants().get(0)).getImplementingElements().get(0);
        Assert.assertThat((String)"Wrong code element.", (Object)jamoppElement.getJamoppElement(), (Matcher)CoreMatchers.instanceOf(LocalVariableStatement.class));
        JaMoPPMergeDecider decider = new JaMoPPMergeDecider();
        Boolean mergeDecision = decider.canBeMerged(vp1, vp2);
        Assert.assertThat((String)"Wrong merge decision", (Object)mergeDecision, (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
    }

    @Test
    public void testUnmergeableStatementsConditionalDevider() throws Exception {
        String basePath = "testcode/unmergeable-statements-conditional/";
        VariationPointModel vpm = this.initializeVariationPointModel(basePath);
        Assert.assertThat((String)"Wrong number of vpm groups", (Object)vpm.getVariationPointGroups().size(), (Matcher)CoreMatchers.is((Object)4));
        VariationPoint vp1 = (VariationPoint)((VariationPointGroup)vpm.getVariationPointGroups().get(0)).getVariationPoints().get(0);
        VariationPoint vp2 = (VariationPoint)((VariationPointGroup)vpm.getVariationPointGroups().get(1)).getVariationPoints().get(0);
        VariationPoint vp3 = (VariationPoint)((VariationPointGroup)vpm.getVariationPointGroups().get(2)).getVariationPoints().get(0);
        VariationPoint vp4 = (VariationPoint)((VariationPointGroup)vpm.getVariationPointGroups().get(3)).getVariationPoints().get(0);
        Assert.assertThat((String)"Wrong number of variants", (Object)vp1.getVariants().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((String)"Wrong number of variants", (Object)vp2.getVariants().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Wrong number of variants", (Object)vp3.getVariants().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Wrong number of variants", (Object)vp4.getVariants().size(), (Matcher)CoreMatchers.is((Object)1));
        JaMoPPMergeDecider decider = new JaMoPPMergeDecider();
        Assert.assertThat((String)"Wrong merge decision 3-4", (Object)decider.canBeMerged(vp3, vp4), (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
    }

    @Test
    public void testMergeableStatements() throws Exception {
        String basePath = "testcode/mergeable-statements/";
        VariationPointModel vpm = this.initializeVariationPointModel(basePath);
        Assert.assertThat((String)"3 VPs = 3 Changed statements", (Object)vpm.getVariationPointGroups().size(), (Matcher)CoreMatchers.is((Object)3));
        VariationPoint vp1 = (VariationPoint)((VariationPointGroup)vpm.getVariationPointGroups().get(0)).getVariationPoints().get(0);
        VariationPoint vp2 = (VariationPoint)((VariationPointGroup)vpm.getVariationPointGroups().get(1)).getVariationPoints().get(0);
        VariationPoint vp3 = (VariationPoint)((VariationPointGroup)vpm.getVariationPointGroups().get(2)).getVariationPoints().get(0);
        JaMoPPMergeDecider decider = new JaMoPPMergeDecider();
        Assert.assertThat((String)"Wrong merge decision VP1 / VP2", (Object)decider.canBeMerged(vp1, vp2), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((String)"Wrong merge decision VP2 / VP3", (Object)decider.canBeMerged(vp2, vp3), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((String)"Wrong merge decision VP1 / VP3", (Object)decider.canBeMerged(vp1, vp3), (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
    }

    private VariationPointModel initializeVariationPointModel(String basePath) throws Exception {
        JaMoPPSoftwareModelExtractor extractor = new JaMoPPSoftwareModelExtractor();
        ArrayList urisA = Lists.newArrayList((Object[])new String[]{new File(String.valueOf(basePath) + "a").getAbsolutePath()});
        ArrayList urisB = Lists.newArrayList((Object[])new String[]{new File(String.valueOf(basePath) + "b").getAbsolutePath()});
        NullProgressMonitor monitor = new NullProgressMonitor();
        ResourceSet setA = extractor.extractSoftwareModel((List)urisA, (IProgressMonitor)monitor, null);
        ResourceSet setB = extractor.extractSoftwareModel((List)urisB, (IProgressMonitor)monitor, null);
        String ignorePackages = this.buildIgnorePackages();
        LinkedHashMap diffOptions = Maps.newLinkedHashMap();
        diffOptions.put("JaMoPP.Java.Packages.to.ignore", ignorePackages);
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(setA, setB, (Map)diffOptions);
        JaMoPPVPMBuilder builder = new JaMoPPVPMBuilder();
        VariationPointModel vpm = builder.buildVPM(comparison, "leading", "integration");
        return vpm;
    }

    private String buildIgnorePackages() {
        StringBuilder sb = new StringBuilder();
        sb.append("java.*");
        sb.append(System.getProperty("line.separator"));
        String ignorePackages = sb.toString();
        return ignorePackages;
    }
}

