/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.software.impl;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.emftext.language.java.commons.Commentable;
import org.emftext.language.java.containers.CompilationUnit;
import org.emftext.language.java.members.Member;
import org.emftext.language.java.statements.Statement;
import org.emftext.language.java.statements.StatementContainer;
import org.emftext.language.java.statements.StatementListContainer;
import org.splevo.jamopp.vpm.software.CommentableSoftwareElement;
import org.splevo.jamopp.vpm.software.impl.JaMoPPJavaSoftwareElementImpl;
import org.splevo.jamopp.vpm.software.softwarePackage;

public class CommentableSoftwareElementImpl
extends JaMoPPJavaSoftwareElementImpl
implements CommentableSoftwareElement {
    private static final String COMMENT_PREFIX = "SPLEVO_REF";
    protected static final String ID_EDEFAULT = null;
    protected String id = ID_EDEFAULT;
    protected CompilationUnit compilationUnit;
    protected Class<? extends Commentable> type = Commentable.class;

    protected CommentableSoftwareElementImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return softwarePackage.Literals.COMMENTABLE_SOFTWARE_ELEMENT;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String newId) {
        String oldId = this.id;
        this.id = newId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldId, (Object)this.id));
        }
    }

    @Override
    public CompilationUnit getCompilationUnit() {
        if (this.compilationUnit != null && this.compilationUnit.eIsProxy()) {
            InternalEObject oldCompilationUnit = (InternalEObject)this.compilationUnit;
            this.compilationUnit = (CompilationUnit)this.eResolveProxy(oldCompilationUnit);
            if (this.compilationUnit != oldCompilationUnit && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 1, (Object)oldCompilationUnit, (Object)this.compilationUnit));
            }
        }
        return this.compilationUnit;
    }

    public CompilationUnit basicGetCompilationUnit() {
        return this.compilationUnit;
    }

    @Override
    public void setCompilationUnit(CompilationUnit newCompilationUnit) {
        CompilationUnit oldCompilationUnit = this.compilationUnit;
        this.compilationUnit = newCompilationUnit;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldCompilationUnit, (Object)this.compilationUnit));
        }
    }

    @Override
    public Class<? extends Commentable> getType() {
        return this.type;
    }

    @Override
    public void setType(Class<? extends Commentable> newType) {
        Class<? extends Commentable> oldType = this.type;
        this.type = Statement.class.isAssignableFrom(newType) && !Member.class.isAssignableFrom(newType) ? Statement.class : newType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldType, this.type));
        }
    }

    public static String buildReferencingCommentText(String id) {
        return String.format("%s %s", COMMENT_PREFIX, id);
    }

    private boolean containsWantedComment(Commentable commentable) {
        return Iterables.any((Iterable)commentable.getComments(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input.contains(CommentableSoftwareElementImpl.buildReferencingCommentText(CommentableSoftwareElementImpl.this.getId()));
            }
        });
    }

    private Optional<Statement> findStatementInContainer(Commentable element) {
        Commentable currentElement = element;
        while (currentElement.eContainer() != null) {
            EObject parent = currentElement.eContainer();
            if (parent instanceof StatementListContainer || parent instanceof StatementContainer) {
                return Optional.of((Object)((Statement)currentElement));
            }
            currentElement = parent;
        }
        return Optional.absent();
    }

    private Optional<? extends Commentable> findParentOfType(Commentable child, Class<? extends Commentable> type) {
        if (type == Statement.class) {
            return this.findStatementInContainer(child);
        }
        Commentable currentObject = child;
        while (currentObject != null) {
            if (type.isAssignableFrom(currentObject.getClass())) {
                return Optional.of((Object)currentObject);
            }
            currentObject = (Commentable)currentObject.eContainer();
        }
        return Optional.absent();
    }

    @Override
    public Commentable resolveJaMoPPElement() {
        if (this.isReferencedElement((Commentable)this.getCompilationUnit()).isPresent()) {
            return this.getCompilationUnit();
        }
        TreeIterator treeIter = this.getCompilationUnit().eAllContents();
        while (treeIter.hasNext()) {
            EObject nextItem = (EObject)treeIter.next();
            if (!(nextItem instanceof Commentable)) {
                treeIter.prune();
                continue;
            }
            Commentable commentable = (Commentable)nextItem;
            Optional<? extends Commentable> foundElement = this.isReferencedElement(commentable);
            if (!foundElement.isPresent()) continue;
            return (Commentable)foundElement.get();
        }
        return null;
    }

    private Optional<? extends Commentable> isReferencedElement(Commentable commentable) {
        if (!this.containsWantedComment(commentable)) {
            return Optional.absent();
        }
        return this.findParentOfType(commentable, this.getType());
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getId();
            }
            case 1: {
                if (resolve) {
                    return this.getCompilationUnit();
                }
                return this.basicGetCompilationUnit();
            }
            case 2: {
                return this.getType();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setId((String)newValue);
                return;
            }
            case 1: {
                this.setCompilationUnit((CompilationUnit)newValue);
                return;
            }
            case 2: {
                this.setType((Class)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setId(ID_EDEFAULT);
                return;
            }
            case 1: {
                this.setCompilationUnit(null);
                return;
            }
            case 2: {
                this.setType(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return ID_EDEFAULT == null ? this.id != null : !ID_EDEFAULT.equals(this.id);
            }
            case 1: {
                return this.compilationUnit != null;
            }
            case 2: {
                return this.type != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (id: ");
        result.append(this.id);
        result.append(", type: ");
        result.append(this.type);
        result.append(')');
        return result.toString();
    }

    @Override
    public Commentable getJamoppElement() {
        return this.resolveJaMoPPElement();
    }
}

