/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.vpm.software.impl;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.emftext.language.java.commons.Commentable;
import org.emftext.language.java.resource.java.IJavaLocationMap;
import org.emftext.language.java.resource.java.mopp.JavaDevNullLocationMap;
import org.emftext.language.java.resource.java.mopp.JavaResource;
import org.splevo.commons.emf.FileResourceHandling;
import org.splevo.jamopp.util.JaMoPPElementUtil;
import org.splevo.jamopp.vpm.software.JaMoPPJavaSoftwareElement;
import org.splevo.jamopp.vpm.software.softwarePackage;
import org.splevo.vpm.software.SoftwareFactory;
import org.splevo.vpm.software.SourceLocation;

public abstract class JaMoPPJavaSoftwareElementImpl
extends MinimalEObjectImpl.Container
implements JaMoPPJavaSoftwareElement {
    private static final Logger LOGGER = Logger.getLogger(JaMoPPJavaSoftwareElementImpl.class);

    protected JaMoPPJavaSoftwareElementImpl() {
    }

    protected EClass eStaticClass() {
        return softwarePackage.Literals.JA_MO_PP_JAVA_SOFTWARE_ELEMENT;
    }

    @Override
    public abstract Commentable getJamoppElement();

    public abstract Commentable resolveJaMoPPElement();

    @Override
    public String getLabel() {
        return JaMoPPElementUtil.getLabel((Commentable)this.resolveJaMoPPElement());
    }

    @Override
    public String getName() {
        return JaMoPPElementUtil.getName((Commentable)this.resolveJaMoPPElement());
    }

    public SourceLocation getSourceLocation() {
        Commentable element = this.resolveJaMoPPElement();
        if (element == null) {
            LOGGER.warn((Object)("Could not resolve JaMoPPElement " + this.toString() + "."));
            return null;
        }
        if (!(element.eResource() instanceof JavaResource)) {
            return null;
        }
        JavaResource resource = (JavaResource)element.eResource();
        IJavaLocationMap locationMap = resource.getLocationMap();
        if (locationMap instanceof JavaDevNullLocationMap) {
            return this.reloadLocation(element, resource);
        }
        return this.buildLocation(element, resource);
    }

    private SourceLocation buildLocation(Commentable element, JavaResource resource) {
        SourceLocation location = SoftwareFactory.eINSTANCE.createSourceLocation();
        File realFilePath = FileResourceHandling.getPhysicalFilePath((Resource)resource);
        location.setFilePath(realFilePath.getAbsolutePath());
        IJavaLocationMap locationMap = resource.getLocationMap();
        location.setStartLine(locationMap.getLine((EObject)element));
        location.setStartPosition(locationMap.getCharStart((EObject)element));
        location.setEndPosition(locationMap.getCharEnd((EObject)element));
        return location;
    }

    private SourceLocation reloadLocation(Commentable element, JavaResource resource) {
        JavaResource reloadedResource = (JavaResource)resource.getResourceSet().createResource(resource.getURI());
        LinkedHashMap options = Maps.newLinkedHashMap();
        options.put("DISABLE_LOCATION_MAP", Boolean.FALSE);
        try {
            reloadedResource.load((Map)options);
        }
        catch (IOException e) {
            return null;
        }
        String uriFragment = resource.getURIFragment((EObject)element);
        Commentable reloadedElement = (Commentable)reloadedResource.getEObject(uriFragment);
        return this.buildLocation(reloadedElement, reloadedResource);
    }

    @Override
    public EObject getWrappedElement() {
        return this.resolveJaMoPPElement();
    }

    @Override
    public String getQualifiedName() {
        return JaMoPPElementUtil.getQualifiedName((Commentable)this.resolveJaMoPPElement());
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 5: {
                return this.getJamoppElement();
            }
            case 6: {
                return this.getLabel();
            }
            case 7: {
                return this.getName();
            }
            case 8: {
                return this.getWrappedElement();
            }
            case 9: {
                return this.getQualifiedName();
            }
            case 2: {
                return this.getSourceLocation();
            }
        }
        return super.eInvoke(operationID, arguments);
    }
}

