/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.project.impl;

import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.splevo.project.ProjectFactory;
import org.splevo.project.ProjectPackage;
import org.splevo.project.QualityGoal;
import org.splevo.project.SPLProfile;
import org.splevo.project.SPLevoProject;
import org.splevo.project.VPMModelReference;
import org.splevo.project.impl.DifferOptionImpl;
import org.splevo.project.impl.SPLProfileImpl;
import org.splevo.project.impl.SPLevoProjectImpl;
import org.splevo.project.impl.VPMModelReferenceImpl;

public class ProjectFactoryImpl
extends EFactoryImpl
implements ProjectFactory {
    public static ProjectFactory init() {
        try {
            ProjectFactory theProjectFactory = (ProjectFactory)EPackage.Registry.INSTANCE.getEFactory("http://org.splevo.project/1.0");
            if (theProjectFactory != null) {
                return theProjectFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ProjectFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createSPLevoProject();
            }
            case 1: {
                return (EObject)this.createDifferOption();
            }
            case 2: {
                return this.createSPLProfile();
            }
            case 3: {
                return this.createVPMModelReference();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.createQualityGoalFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.convertQualityGoalToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public SPLevoProject createSPLevoProject() {
        SPLevoProjectImpl spLevoProject = new SPLevoProjectImpl();
        return spLevoProject;
    }

    public Map.Entry<String, String> createDifferOption() {
        DifferOptionImpl differOption = new DifferOptionImpl();
        return differOption;
    }

    @Override
    public SPLProfile createSPLProfile() {
        SPLProfileImpl splProfile = new SPLProfileImpl();
        return splProfile;
    }

    @Override
    public VPMModelReference createVPMModelReference() {
        VPMModelReferenceImpl vpmModelReference = new VPMModelReferenceImpl();
        return vpmModelReference;
    }

    public QualityGoal createQualityGoalFromString(EDataType eDataType, String initialValue) {
        QualityGoal result = QualityGoal.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertQualityGoalToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public ProjectPackage getProjectPackage() {
        return (ProjectPackage)this.getEPackage();
    }

    @Deprecated
    public static ProjectPackage getPackage() {
        return ProjectPackage.eINSTANCE;
    }
}

