/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.project.utils;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.splevo.commons.emf.SPLevoResourceSet;
import org.splevo.project.ProjectPackage;
import org.splevo.project.SPLevoProject;

public class SPLevoProjectUtil {
    public static final String SPLEVO_FILE_EXTENSION = "splevoproject";
    public static final String NATURE_ID = "org.splevo.ui.splevonature";
    private static final Logger LOGGER = Logger.getLogger(SPLevoProjectUtil.class);

    public static SPLevoProject loadSPLevoProjectModel(IProject consolidationProject) throws IOException {
        Optional<IFile> projectFile = SPLevoProjectUtil.findSPLevoProjectFile(consolidationProject);
        if (projectFile.isPresent()) {
            return SPLevoProjectUtil.loadSPLevoProjectModel((IFile)projectFile.get());
        }
        return null;
    }

    public static SPLevoProject loadSPLevoProjectModel(IFile splevoProjectFile) throws IOException {
        return SPLevoProjectUtil.loadSPLevoProjectModel(splevoProjectFile.getFullPath().toFile());
    }

    public static SPLevoProject loadSPLevoProjectModel(File splevoProjectFile) throws IOException {
        ProjectPackage.eINSTANCE.eClass();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(SPLEVO_FILE_EXTENSION, new XMIResourceFactoryImpl());
        SPLevoResourceSet rs = new SPLevoResourceSet();
        Resource r = rs.createResource(URI.createPlatformResourceURI((String)splevoProjectFile.getPath(), (boolean)true));
        r.load(null);
        EcoreUtil.resolveAll((ResourceSet)rs);
        EObject model = (EObject)r.getContents().get(0);
        if (!(model instanceof SPLevoProject)) {
            throw new IOException("Model is not a valid SPLevoProject: " + model.getClass().getName());
        }
        SPLevoProject splEvoProjectModel = (SPLevoProject)model;
        return splEvoProjectModel;
    }

    public static void save(SPLevoProject project, File filePath) throws IOException {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put(SPLEVO_FILE_EXTENSION, new XMIResourceFactoryImpl());
        SPLevoResourceSet resSet = new SPLevoResourceSet();
        Resource resource = resSet.createResource(URI.createPlatformResourceURI((String)filePath.getPath(), (boolean)true));
        resource.getContents().add((Object)project);
        resource.save(Collections.EMPTY_MAP);
    }

    public static boolean isSPLevoProject(IProject project) {
        try {
            return project.hasNature(NATURE_ID);
        }
        catch (CoreException e) {
            return false;
        }
    }

    public static Iterable<IProject> findAllSPLevoProjectsInWorkspace(final boolean onlyOpenProjects) {
        return Iterables.filter((Iterable)Lists.newArrayList((Object[])ResourcesPlugin.getWorkspace().getRoot().getProjects()), (Predicate)new Predicate<IProject>(){

            public boolean apply(IProject arg0) {
                return (!onlyOpenProjects || arg0.isOpen()) && SPLevoProjectUtil.isSPLevoProject(arg0);
            }
        });
    }

    public static Optional<IFile> findSPLevoProjectFile(IProject project) {
        SPLevoProjectVisitor visitor = new SPLevoProjectVisitor();
        try {
            project.accept((IResourceVisitor)visitor);
        }
        catch (CoreException e) {
            LOGGER.warn((Object)"Error looking for the SPLevo project model file.", (Throwable)e);
            return null;
        }
        return Optional.fromNullable((Object)visitor.getSPLevoProjectFile());
    }

    private static class SPLevoProjectVisitor
    implements IResourceVisitor {
        private IFile splevoProjectModelFile = null;

        private SPLevoProjectVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (this.splevoProjectModelFile != null) {
                return false;
            }
            if ((resource.getType() & 1) != 0 && resource.getName().endsWith(SPLevoProjectUtil.SPLEVO_FILE_EXTENSION)) {
                this.splevoProjectModelFile = (IFile)resource;
            }
            return true;
        }

        public IFile getSPLevoProjectFile() {
            return this.splevoProjectModelFile;
        }
    }
}

