/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.refactoring;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.splevo.commons.eclipse.ExtensionHelper;
import org.splevo.refactoring.TodoTagCustomizer;
import org.splevo.refactoring.TodoTagCustomizerRegistry;
import org.splevo.refactoring.VariabilityRefactoring;
import org.splevo.refactoring.VariabilityRefactoringRegistry;

public class Activator
implements BundleActivator {
    private static final String REFACTORING_EXTENSION_POINT_ID = "org.splevo.refactoring.refactoring";
    private static final String EXTENSION_POINT_ATTR_REFACTORING_CLASS = "refactoring.class";
    private static final String TODOTAGCUSTOMIZER_EXTENSION_POINT_ID = "org.splevo.refactoring.todotags";
    private static Logger logger = Logger.getLogger(Activator.class);

    public void start(BundleContext bundleContext) throws Exception {
        List<VariabilityRefactoring> refactorings = this.loadRefactorings();
        for (VariabilityRefactoring refactoring : refactorings) {
            VariabilityRefactoringRegistry.getInstance().registerElement(refactoring);
        }
        for (TodoTagCustomizer customizer : this.loadTodoTagCustomizers()) {
            TodoTagCustomizerRegistry.getInstance().registerElement(customizer);
            customizer.adjustTodoTags();
        }
    }

    public List<VariabilityRefactoring> loadRefactorings() {
        IExtension[] extensions;
        LinkedList<VariabilityRefactoring> refactoringList = new LinkedList<VariabilityRefactoring>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            logger.warn((Object)"No extension point registry available.");
            return null;
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(REFACTORING_EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            logger.warn((Object)"No extension point found for the ID org.splevo.refactoring.refactoring");
            return null;
        }
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configurations;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configurations = extension.getConfigurationElements();
            int n3 = configurations.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    Object o = element.createExecutableExtension(EXTENSION_POINT_ATTR_REFACTORING_CLASS);
                    if (o != null && o instanceof VariabilityRefactoring) {
                        VariabilityRefactoring refactoring = (VariabilityRefactoring)o;
                        refactoringList.add(refactoring);
                    }
                }
                catch (CoreException e) {
                    logger.error((Object)"Failed to load refactoring extension", (Throwable)e);
                }
                ++n4;
            }
            ++n2;
        }
        if (this.refactoringIdsNotUnique(refactoringList)) {
            logger.warn((Object)"Two or more refactorings with the same id loaded.");
        }
        if (this.refactoringLabelsNotUnique(refactoringList)) {
            logger.warn((Object)"Two or more refactorings with the same label loaded.");
        }
        return refactoringList;
    }

    private boolean refactoringIdsNotUnique(List<VariabilityRefactoring> refactorings) {
        LinkedList<String> ids = new LinkedList<String>();
        for (VariabilityRefactoring refactoring : refactorings) {
            if (ids.contains(refactoring.getId())) {
                return true;
            }
            ids.add(refactoring.getId());
        }
        return false;
    }

    private boolean refactoringLabelsNotUnique(List<VariabilityRefactoring> refactorings) {
        LinkedList<String> refactoringIds = new LinkedList<String>();
        for (VariabilityRefactoring refactoring : refactorings) {
            if (refactoringIds.contains(refactoring.getId())) {
                return true;
            }
            refactoringIds.add(refactoring.getId());
        }
        return false;
    }

    private Iterable<TodoTagCustomizer> loadTodoTagCustomizers() {
        try {
            return ExtensionHelper.getAllRegisteredExtensions((String)TODOTAGCUSTOMIZER_EXTENSION_POINT_ID, TodoTagCustomizer.class);
        }
        catch (BundleException e) {
            logger.error((Object)"Could not load TODO tag customizers.", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }
}

